/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.batch.handler;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.StreamsEventResponse;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.batch.handler.BatchMessageHandler;
import software.amazon.lambda.powertools.utilities.EventDeserializer;

public class KinesisStreamsBatchMessageHandler<M>
implements BatchMessageHandler<KinesisEvent, StreamsEventResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KinesisStreamsBatchMessageHandler.class);
    private final BiConsumer<KinesisEvent.KinesisEventRecord, Context> rawMessageHandler;
    private final BiConsumer<M, Context> messageHandler;
    private final Class<M> messageClass;
    private final Consumer<KinesisEvent.KinesisEventRecord> successHandler;
    private final BiConsumer<KinesisEvent.KinesisEventRecord, Throwable> failureHandler;

    public KinesisStreamsBatchMessageHandler(BiConsumer<KinesisEvent.KinesisEventRecord, Context> rawMessageHandler, BiConsumer<M, Context> messageHandler, Class<M> messageClass, Consumer<KinesisEvent.KinesisEventRecord> successHandler, BiConsumer<KinesisEvent.KinesisEventRecord, Throwable> failureHandler) {
        this.rawMessageHandler = rawMessageHandler;
        this.messageHandler = messageHandler;
        this.messageClass = messageClass;
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
    }

    @Override
    public StreamsEventResponse processBatch(KinesisEvent event, Context context) {
        ArrayList<StreamsEventResponse.BatchItemFailure> batchFailures = new ArrayList<StreamsEventResponse.BatchItemFailure>();
        for (KinesisEvent.KinesisEventRecord record : event.getRecords()) {
            try {
                if (this.rawMessageHandler != null) {
                    this.rawMessageHandler.accept(record, context);
                } else {
                    Object messageDeserialized = EventDeserializer.extractDataFrom((Object)record).as(this.messageClass);
                    this.messageHandler.accept(messageDeserialized, context);
                }
                if (this.successHandler == null) continue;
                this.successHandler.accept(record);
            }
            catch (Throwable t) {
                String sequenceNumber = record.getEventID();
                LOGGER.error("Error while processing record with eventID {}: {}, adding it to batch item failures", (Object)sequenceNumber, (Object)t.getMessage());
                LOGGER.error("Error was", t);
                batchFailures.add(new StreamsEventResponse.BatchItemFailure(record.getKinesis().getSequenceNumber()));
                if (this.failureHandler == null) continue;
                try {
                    this.failureHandler.accept(record, t);
                }
                catch (Throwable t2) {
                    LOGGER.warn("failureHandler threw handling failure", t2);
                }
            }
        }
        return new StreamsEventResponse(batchFailures);
    }
}

