/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.batch.handler;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.SQSBatchResponse;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.batch.handler.BatchMessageHandler;
import software.amazon.lambda.powertools.utilities.EventDeserializer;

public class SqsBatchMessageHandler<M>
implements BatchMessageHandler<SQSEvent, SQSBatchResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqsBatchMessageHandler.class);
    private static final String MESSAGE_GROUP_ID_KEY = "MessageGroupId";
    private final Class<M> messageClass;
    private final BiConsumer<M, Context> messageHandler;
    private final BiConsumer<SQSEvent.SQSMessage, Context> rawMessageHandler;
    private final Consumer<SQSEvent.SQSMessage> successHandler;
    private final BiConsumer<SQSEvent.SQSMessage, Throwable> failureHandler;

    public SqsBatchMessageHandler(BiConsumer<M, Context> messageHandler, Class<M> messageClass, BiConsumer<SQSEvent.SQSMessage, Context> rawMessageHandler, Consumer<SQSEvent.SQSMessage> successHandler, BiConsumer<SQSEvent.SQSMessage, Throwable> failureHandler) {
        this.messageHandler = messageHandler;
        this.messageClass = messageClass;
        this.rawMessageHandler = rawMessageHandler;
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
    }

    @Override
    public SQSBatchResponse processBatch(SQSEvent event, Context context) {
        int messageCursor;
        SQSBatchResponse response = SQSBatchResponse.builder().withBatchItemFailures(new ArrayList()).build();
        boolean failWholeBatch = false;
        for (messageCursor = 0; messageCursor < event.getRecords().size() && !failWholeBatch; ++messageCursor) {
            SQSEvent.SQSMessage message2 = (SQSEvent.SQSMessage)event.getRecords().get(messageCursor);
            String messageGroupId = message2.getAttributes() != null ? (String)message2.getAttributes().get(MESSAGE_GROUP_ID_KEY) : null;
            try {
                if (this.rawMessageHandler != null) {
                    this.rawMessageHandler.accept(message2, context);
                } else {
                    Object messageDeserialized = EventDeserializer.extractDataFrom((Object)message2).as(this.messageClass);
                    this.messageHandler.accept(messageDeserialized, context);
                }
                if (this.successHandler == null) continue;
                this.successHandler.accept(message2);
                continue;
            }
            catch (Throwable t) {
                LOGGER.error("Error while processing message with messageId {}: {}, adding it to batch item failures", (Object)message2.getMessageId(), (Object)t.getMessage());
                LOGGER.error("Error was", t);
                response.getBatchItemFailures().add(SQSBatchResponse.BatchItemFailure.builder().withItemIdentifier(message2.getMessageId()).build());
                if (messageGroupId != null) {
                    failWholeBatch = true;
                    LOGGER.info("A message in a batch with messageGroupId {} and messageId {} failed; failing the rest of the batch too", (Object)messageGroupId, (Object)message2.getMessageId());
                }
                if (this.failureHandler == null) continue;
                try {
                    this.failureHandler.accept(message2, t);
                    continue;
                }
                catch (Throwable t2) {
                    LOGGER.warn("failureHandler threw handling failure", t2);
                }
            }
        }
        if (failWholeBatch) {
            event.getRecords().subList(messageCursor, event.getRecords().size()).forEach(message -> response.getBatchItemFailures().add(SQSBatchResponse.BatchItemFailure.builder().withItemIdentifier(message.getMessageId()).build()));
        }
        return response;
    }
}

