/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.idempotency;

import com.amazonaws.services.lambda.runtime.Context;
import java.time.Duration;

public class IdempotencyConfig {
    private final int localCacheMaxItems;
    private final boolean useLocalCache;
    private final long expirationInSeconds;
    private final String eventKeyJMESPath;
    private final String payloadValidationJMESPath;
    private final boolean throwOnNoIdempotencyKey;
    private final String hashFunction;
    private Context lambdaContext;

    private IdempotencyConfig(String eventKeyJMESPath, String payloadValidationJMESPath, boolean throwOnNoIdempotencyKey, boolean useLocalCache, int localCacheMaxItems, long expirationInSeconds, String hashFunction) {
        this.localCacheMaxItems = localCacheMaxItems;
        this.useLocalCache = useLocalCache;
        this.expirationInSeconds = expirationInSeconds;
        this.eventKeyJMESPath = eventKeyJMESPath;
        this.payloadValidationJMESPath = payloadValidationJMESPath;
        this.throwOnNoIdempotencyKey = throwOnNoIdempotencyKey;
        this.hashFunction = hashFunction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getLocalCacheMaxItems() {
        return this.localCacheMaxItems;
    }

    public boolean useLocalCache() {
        return this.useLocalCache;
    }

    public long getExpirationInSeconds() {
        return this.expirationInSeconds;
    }

    public String getEventKeyJMESPath() {
        return this.eventKeyJMESPath;
    }

    public String getPayloadValidationJMESPath() {
        return this.payloadValidationJMESPath;
    }

    public boolean throwOnNoIdempotencyKey() {
        return this.throwOnNoIdempotencyKey;
    }

    public String getHashFunction() {
        return this.hashFunction;
    }

    public Context getLambdaContext() {
        return this.lambdaContext;
    }

    public void setLambdaContext(Context lambdaContext) {
        this.lambdaContext = lambdaContext;
    }

    /* synthetic */ IdempotencyConfig(String string, String string2, boolean bl, boolean bl2, int n, long l, String string3, IdempotencyConfig idempotencyConfig) {
        this(string, string2, bl, bl2, n, l, string3);
    }

    public static class Builder {
        private int localCacheMaxItems = 256;
        private boolean useLocalCache = false;
        private long expirationInSeconds = 3600L;
        private String eventKeyJMESPath;
        private String payloadValidationJMESPath;
        private boolean throwOnNoIdempotencyKey = false;
        private String hashFunction = "MD5";

        public IdempotencyConfig build() {
            return new IdempotencyConfig(this.eventKeyJMESPath, this.payloadValidationJMESPath, this.throwOnNoIdempotencyKey, this.useLocalCache, this.localCacheMaxItems, this.expirationInSeconds, this.hashFunction, null);
        }

        public Builder withEventKeyJMESPath(String eventKeyJMESPath) {
            this.eventKeyJMESPath = eventKeyJMESPath;
            return this;
        }

        public Builder withLocalCacheMaxItems(int localCacheMaxItems) {
            this.localCacheMaxItems = localCacheMaxItems;
            return this;
        }

        public Builder withUseLocalCache(boolean useLocalCache) {
            this.useLocalCache = useLocalCache;
            return this;
        }

        public Builder withExpiration(Duration expiration) {
            this.expirationInSeconds = expiration.getSeconds();
            return this;
        }

        public Builder withPayloadValidationJMESPath(String payloadValidationJMESPath) {
            this.payloadValidationJMESPath = payloadValidationJMESPath;
            return this;
        }

        public Builder withThrowOnNoIdempotencyKey(boolean throwOnNoIdempotencyKey) {
            this.throwOnNoIdempotencyKey = throwOnNoIdempotencyKey;
            return this;
        }

        public Builder withThrowOnNoIdempotencyKey() {
            return this.withThrowOnNoIdempotencyKey(true);
        }

        public Builder withHashFunction(String hashFunction) {
            this.hashFunction = hashFunction;
            return this;
        }
    }
}

