/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.idempotency.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclarePrecedence;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.idempotency.Idempotency;
import software.amazon.lambda.powertools.idempotency.IdempotencyKey;
import software.amazon.lambda.powertools.idempotency.Idempotent;
import software.amazon.lambda.powertools.idempotency.exceptions.IdempotencyConfigurationException;
import software.amazon.lambda.powertools.idempotency.internal.IdempotencyHandler;
import software.amazon.lambda.powertools.utilities.JsonConfig;

@Aspect
@DeclarePrecedence(value="software.amazon.lambda.powertools.idempotency.internal.IdempotentAspect, *")
public class IdempotentAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ IdempotentAspect ajc$perSingletonInstance;

    @Pointcut(value="@annotation(idempotent)")
    public /* synthetic */ void callAt(Idempotent idempotent) {
    }

    @Around(value="callAt(idempotent) && execution(@Idempotent * *.*(..))", argNames="pjp,idempotent")
    public Object around(ProceedingJoinPoint pjp, Idempotent idempotent) throws Throwable {
        String idempotencyDisabledEnv = System.getenv().get("POWERTOOLS_IDEMPOTENCY_DISABLED");
        if (idempotencyDisabledEnv != null && !"false".equalsIgnoreCase(idempotencyDisabledEnv)) {
            return pjp.proceed(pjp.getArgs());
        }
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new IdempotencyConfigurationException("The annotated method doesn't return anything. Unable to perform idempotency on void return type");
        }
        boolean isHandler = LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp);
        JsonNode payload = this.getPayload(pjp, method, isHandler);
        if (payload == null) {
            throw new IdempotencyConfigurationException("Unable to get payload from the method. Ensure there is at least one parameter or that you use @IdempotencyKey");
        }
        Context lambdaContext = isHandler ? (Context)pjp.getArgs()[1] : Idempotency.getInstance().getConfig().getLambdaContext();
        IdempotencyHandler idempotencyHandler = new IdempotencyHandler(pjp, method.getName(), payload, lambdaContext);
        return idempotencyHandler.handle();
    }

    private JsonNode getPayload(ProceedingJoinPoint pjp, Method method, boolean isHandler) {
        JsonNode payload = null;
        if (isHandler || pjp.getArgs().length == 1) {
            payload = JsonConfig.get().getObjectMapper().valueToTree(pjp.getArgs()[0]);
        } else {
            Annotation[][] annotations = method.getParameterAnnotations();
            int i = 0;
            while (i < annotations.length && payload == null) {
                Annotation[] annotationsRow = annotations[i];
                int j = 0;
                while (j < annotationsRow.length && payload == null) {
                    if (annotationsRow[j].annotationType().equals(IdempotencyKey.class)) {
                        payload = JsonConfig.get().getObjectMapper().valueToTree(pjp.getArgs()[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return payload;
    }

    public static IdempotentAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.idempotency.internal.IdempotentAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            IdempotentAspect.ajc$perSingletonInstance = new IdempotentAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

