/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.idempotency.persistence;

import java.time.Instant;
import java.util.Objects;
import java.util.OptionalLong;

public class DataRecord {
    private final String idempotencyKey;
    private final String status;
    private final long expiryTimestamp;
    private final String responseData;
    private final String payloadHash;
    private final OptionalLong inProgressExpiryTimestamp;

    public DataRecord(String idempotencyKey, Status status, long expiryTimestamp, String responseData, String payloadHash) {
        this.idempotencyKey = idempotencyKey;
        this.status = status.toString();
        this.expiryTimestamp = expiryTimestamp;
        this.responseData = responseData;
        this.payloadHash = payloadHash;
        this.inProgressExpiryTimestamp = OptionalLong.empty();
    }

    public DataRecord(String idempotencyKey, Status status, long expiryTimestamp, String responseData, String payloadHash, OptionalLong inProgressExpiryTimestamp) {
        this.idempotencyKey = idempotencyKey;
        this.status = status.toString();
        this.expiryTimestamp = expiryTimestamp;
        this.responseData = responseData;
        this.payloadHash = payloadHash;
        this.inProgressExpiryTimestamp = inProgressExpiryTimestamp;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean isExpired(Instant now) {
        return this.expiryTimestamp != 0L && now.isAfter(Instant.ofEpochSecond(this.expiryTimestamp));
    }

    public Status getStatus() {
        Instant now = Instant.now();
        if (this.isExpired(now)) {
            return Status.EXPIRED;
        }
        return Status.valueOf(this.status);
    }

    public long getExpiryTimestamp() {
        return this.expiryTimestamp;
    }

    public OptionalLong getInProgressExpiryTimestamp() {
        return this.inProgressExpiryTimestamp;
    }

    public String getResponseData() {
        return this.responseData;
    }

    public String getPayloadHash() {
        return this.payloadHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRecord record = (DataRecord)o;
        return this.expiryTimestamp == record.expiryTimestamp && this.idempotencyKey.equals(record.idempotencyKey) && this.status.equals(record.status) && Objects.equals(this.responseData, record.responseData) && Objects.equals(this.payloadHash, record.payloadHash);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.status, this.expiryTimestamp, this.responseData, this.payloadHash);
    }

    public static enum Status {
        INPROGRESS("INPROGRESS"),
        COMPLETED("COMPLETED"),
        EXPIRED("EXPIRED");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

