/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.metrics;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.cloudwatchlogs.emf.config.SystemWrapper;
import software.amazon.cloudwatchlogs.emf.environment.EnvironmentProvider;
import software.amazon.cloudwatchlogs.emf.logger.MetricsLogger;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.model.MetricsLoggerHelper;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;

public final class MetricsUtils {
    private static final MetricsLogger metricsLogger = new MetricsLogger();
    private static DimensionSet[] defaultDimensions;

    private MetricsUtils() {
    }

    public static MetricsLogger metricsLogger() {
        return metricsLogger;
    }

    public static void defaultDimensions(DimensionSet ... dimensionSets) {
        defaultDimensions = dimensionSets;
    }

    @Deprecated
    public static void defaultDimensionSet(DimensionSet dimensionSet) {
        Objects.requireNonNull(dimensionSet, "Null dimension set not allowed");
        if (dimensionSet.getDimensionKeys().size() > 0) {
            MetricsUtils.defaultDimensions(dimensionSet);
        }
    }

    public static void withSingleMetric(String name, double value, Unit unit, Consumer<MetricsLogger> logger) {
        MetricsLogger metricsLogger = MetricsUtils.logger();
        try {
            metricsLogger.setNamespace(MetricsUtils.defaultNameSpace());
            metricsLogger.putMetric(name, value, unit);
            MetricsUtils.captureRequestAndTraceId(metricsLogger);
            logger.accept(metricsLogger);
        }
        finally {
            metricsLogger.flush();
        }
    }

    public static void withSingleMetric(String name, double value, Unit unit, String namespace, Consumer<MetricsLogger> logger) {
        MetricsLogger metricsLogger = MetricsUtils.logger();
        try {
            metricsLogger.setNamespace(namespace);
            metricsLogger.putMetric(name, value, unit);
            MetricsUtils.captureRequestAndTraceId(metricsLogger);
            logger.accept(metricsLogger);
        }
        finally {
            metricsLogger.flush();
        }
    }

    public static DimensionSet[] getDefaultDimensions() {
        return Arrays.copyOf(defaultDimensions, defaultDimensions.length);
    }

    public static boolean hasDefaultDimension() {
        return defaultDimensions != null;
    }

    private static void captureRequestAndTraceId(MetricsLogger metricsLogger) {
        MetricsUtils.awsRequestId().ifPresent(requestId -> {
            MetricsLogger metricsLogger2 = metricsLogger.putProperty("function_request_id", requestId);
        });
        LambdaHandlerProcessor.getXrayTraceId().ifPresent(traceId -> {
            MetricsLogger metricsLogger2 = metricsLogger.putProperty("xray_trace_id", traceId);
        });
    }

    private static String defaultNameSpace() {
        MetricsContext context = MetricsLoggerHelper.metricsContext();
        return "aws-embedded-metrics".equals(context.getNamespace()) ? SystemWrapper.getenv((String)"POWERTOOLS_METRICS_NAMESPACE") : context.getNamespace();
    }

    private static Optional<String> awsRequestId() {
        MetricsContext context = MetricsLoggerHelper.metricsContext();
        return Optional.ofNullable(context.getProperty("function_request_id")).map(Object::toString);
    }

    private static MetricsLogger logger() {
        MetricsContext metricsContext = new MetricsContext();
        if (MetricsUtils.hasDefaultDimension()) {
            metricsContext.setDimensions(defaultDimensions);
        }
        return new MetricsLogger(new EnvironmentProvider(), metricsContext);
    }
}

