/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.sqs;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.lambda.powertools.sqs.SqsMessageHandler;
import software.amazon.lambda.powertools.sqs.internal.BatchContext;
import software.amazon.lambda.powertools.sqs.internal.SqsLargeMessageAspect;
import software.amazon.payloadoffloading.PayloadS3Pointer;

public final class SqsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SqsUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static SqsClient client;
    private static S3Client s3Client;

    private SqsUtils() {
    }

    public static <R> R enrichedMessageFromS3(SQSEvent sqsEvent, Function<List<SQSEvent.SQSMessage>, R> messageFunction) {
        return SqsUtils.enrichedMessageFromS3(sqsEvent, true, messageFunction);
    }

    public static <R> R enrichedMessageFromS3(SQSEvent sqsEvent, boolean deleteS3Payload, Function<List<SQSEvent.SQSMessage>, R> messageFunction) {
        List<SQSEvent.SQSMessage> sqsMessages = sqsEvent.getRecords().stream().map(SqsUtils::clonedMessage).collect(Collectors.toList());
        List<PayloadS3Pointer> s3Pointers = SqsLargeMessageAspect.processMessages(sqsMessages);
        R returnValue = messageFunction.apply(sqsMessages);
        if (deleteS3Payload) {
            s3Pointers.forEach(SqsLargeMessageAspect::deleteMessage);
        }
        return returnValue;
    }

    public static void overrideSqsClient(SqsClient client) {
        SqsUtils.client = client;
    }

    public static void overrideS3Client(S3Client s3Client) {
        SqsUtils.s3Client = s3Client;
    }

    public static <R> List<R> batchProcessor(SQSEvent event, Class<? extends SqsMessageHandler<R>> handler) {
        return SqsUtils.batchProcessor(event, false, handler);
    }

    @SafeVarargs
    public static <R> List<R> batchProcessor(SQSEvent event, Class<? extends SqsMessageHandler<R>> handler, Class<? extends Exception> ... nonRetryableExceptions) {
        return SqsUtils.batchProcessor(event, false, handler, nonRetryableExceptions);
    }

    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, Class<? extends SqsMessageHandler<R>> handler) {
        SqsMessageHandler<R> handlerInstance = SqsUtils.instantiatedHandler(handler);
        return SqsUtils.batchProcessor(event, suppressException, handlerInstance);
    }

    @SafeVarargs
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, Class<? extends SqsMessageHandler<R>> handler, Class<? extends Exception> ... nonRetryableExceptions) {
        SqsMessageHandler<R> handlerInstance = SqsUtils.instantiatedHandler(handler);
        return SqsUtils.batchProcessor(event, suppressException, handlerInstance, false, nonRetryableExceptions);
    }

    @SafeVarargs
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, Class<? extends SqsMessageHandler<R>> handler, boolean deleteNonRetryableMessageFromQueue, Class<? extends Exception> ... nonRetryableExceptions) {
        SqsMessageHandler<R> handlerInstance = SqsUtils.instantiatedHandler(handler);
        return SqsUtils.batchProcessor(event, suppressException, handlerInstance, deleteNonRetryableMessageFromQueue, nonRetryableExceptions);
    }

    public static <R> List<R> batchProcessor(SQSEvent event, SqsMessageHandler<R> handler) {
        return SqsUtils.batchProcessor(event, false, handler);
    }

    @SafeVarargs
    public static <R> List<R> batchProcessor(SQSEvent event, SqsMessageHandler<R> handler, Class<? extends Exception> ... nonRetryableExceptions) {
        return SqsUtils.batchProcessor(event, false, handler, false, nonRetryableExceptions);
    }

    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, SqsMessageHandler<R> handler) {
        return SqsUtils.batchProcessor(event, suppressException, handler, false, new Class[0]);
    }

    @SafeVarargs
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, SqsMessageHandler<R> handler, boolean deleteNonRetryableMessageFromQueue, Class<? extends Exception> ... nonRetryableExceptions) {
        ArrayList<R> handlerReturn = new ArrayList<R>();
        if (client == null) {
            client = SqsClient.create();
        }
        BatchContext batchContext = new BatchContext(client);
        for (SQSEvent.SQSMessage message : event.getRecords()) {
            try {
                handlerReturn.add(handler.process(message));
                batchContext.addSuccess(message);
            }
            catch (Exception e) {
                batchContext.addFailure(message, e);
            }
        }
        batchContext.processSuccessAndHandleFailed(handlerReturn, suppressException, deleteNonRetryableMessageFromQueue, nonRetryableExceptions);
        return handlerReturn;
    }

    private static <R> SqsMessageHandler<R> instantiatedHandler(Class<? extends SqsMessageHandler<R>> handler) {
        try {
            if (handler.getDeclaringClass() == null) {
                return handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Constructor<SqsMessageHandler<R>> constructor = handler.getDeclaredConstructor(handler.getDeclaringClass());
            constructor.setAccessible(true);
            return constructor.newInstance(handler.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            LOG.error("Failed creating handler instance", (Throwable)e);
            throw new RuntimeException("Unexpected error occurred. Please raise issue at https://github.com/awslabs/aws-lambda-powertools-java/issues", e);
        }
    }

    private static SQSEvent.SQSMessage clonedMessage(SQSEvent.SQSMessage sqsMessage) {
        try {
            return (SQSEvent.SQSMessage)objectMapper.readValue(objectMapper.writeValueAsString((Object)sqsMessage), SQSEvent.SQSMessage.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper objectMapper() {
        return objectMapper;
    }

    public static S3Client s3Client() {
        if (s3Client == null) {
            s3Client = S3Client.create();
        }
        return s3Client;
    }
}

