/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.sqs.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.sqs.SqsLargeMessage;
import software.amazon.lambda.powertools.sqs.SqsUtils;
import software.amazon.payloadoffloading.PayloadS3Pointer;

@Aspect
public class SqsLargeMessageAspect {
    private static final Logger LOG = LoggerFactory.getLogger(SqsLargeMessageAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ SqsLargeMessageAspect ajc$perSingletonInstance;

    static {
        try {
            SqsLargeMessageAspect.ajc$perSingletonInstance = new SqsLargeMessageAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(sqsLargeMessage)")
    public /* synthetic */ void callAt(SqsLargeMessage sqsLargeMessage) {
    }

    @Around(value="callAt(sqsLargeMessage) && execution(@SqsLargeMessage * *.*(..))", argNames="pjp,sqsLargeMessage")
    public Object around(ProceedingJoinPoint pjp, SqsLargeMessage sqsLargeMessage) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp) && SqsLargeMessageAspect.placedOnSqsEventRequestHandler(pjp)) {
            List pointersToDelete = this.rewriteMessages((SQSEvent)proceedArgs[0]);
            Object proceed = pjp.proceed(proceedArgs);
            if (sqsLargeMessage.deletePayloads()) {
                pointersToDelete.forEach(SqsLargeMessageAspect::deleteMessage);
            }
            return proceed;
        }
        return pjp.proceed(proceedArgs);
    }

    private List<PayloadS3Pointer> rewriteMessages(SQSEvent sqsEvent) {
        List records = sqsEvent.getRecords();
        return SqsLargeMessageAspect.processMessages(records);
    }

    public static List<PayloadS3Pointer> processMessages(List<SQSEvent.SQSMessage> records) {
        ArrayList<PayloadS3Pointer> s3Pointers = new ArrayList<PayloadS3Pointer>();
        for (SQSEvent.SQSMessage sqsMessage : records) {
            if (!SqsLargeMessageAspect.isBodyLargeMessagePointer(sqsMessage.getBody())) continue;
            PayloadS3Pointer s3Pointer = PayloadS3Pointer.fromJson(sqsMessage.getBody()).orElseThrow(() -> new FailedProcessingLargePayloadException(String.format("Failed processing SQS body to extract S3 details. [ %s ].", sqsMessage.getBody())));
            ResponseInputStream s3Object = SqsLargeMessageAspect.callS3Gracefully(s3Pointer, pointer -> {
                ResponseInputStream response = SqsUtils.s3Client().getObject((GetObjectRequest)GetObjectRequest.builder().bucket(pointer.getS3BucketName()).key(pointer.getS3Key()).build());
                LOG.debug("Object downloaded with key: " + s3Pointer.getS3Key());
                return response;
            });
            sqsMessage.setBody(SqsLargeMessageAspect.readStringFromS3Object((ResponseInputStream<GetObjectResponse>)s3Object, s3Pointer));
            s3Pointers.add(s3Pointer);
        }
        return s3Pointers;
    }

    private static boolean isBodyLargeMessagePointer(String record) {
        return record.startsWith("[\"software.amazon.payloadoffloading.PayloadS3Pointer\"");
    }

    private static String readStringFromS3Object(ResponseInputStream<GetObjectResponse> response, PayloadS3Pointer s3Pointer) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ResponseInputStream<GetObjectResponse> content = response;){
                return IoUtils.toUtf8String(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("Error converting S3 object to String", (Throwable)e);
            throw new FailedProcessingLargePayloadException(String.format("Failed processing S3 record with [Bucket Name: %s Bucket Key: %s]", s3Pointer.getS3BucketName(), s3Pointer.getS3Key()), e);
        }
    }

    public static void deleteMessage(PayloadS3Pointer s3Pointer) {
        SqsLargeMessageAspect.callS3Gracefully(s3Pointer, pointer -> {
            SqsUtils.s3Client().deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(pointer.getS3BucketName()).key(pointer.getS3Key()).build());
            LOG.info("Message deleted from S3: " + s3Pointer.toJson());
            return null;
        });
    }

    private static <R> R callS3Gracefully(PayloadS3Pointer pointer, Function<PayloadS3Pointer, R> function) {
        try {
            return function.apply(pointer);
        }
        catch (S3Exception e) {
            LOG.error("A service exception", (Throwable)e);
            throw new FailedProcessingLargePayloadException(String.format("Failed processing S3 record with [Bucket Name: %s Bucket Key: %s]", pointer.getS3BucketName(), pointer.getS3Key()), e);
        }
        catch (SdkClientException e) {
            LOG.error("Some sort of client exception", (Throwable)e);
            throw new FailedProcessingLargePayloadException(String.format("Failed processing S3 record with [Bucket Name: %s Bucket Key: %s]", pointer.getS3BucketName(), pointer.getS3Key()), e);
        }
    }

    public static boolean placedOnSqsEventRequestHandler(ProceedingJoinPoint pjp) {
        return pjp.getArgs().length == 2 && pjp.getArgs()[0] instanceof SQSEvent && pjp.getArgs()[1] instanceof Context;
    }

    public static SqsLargeMessageAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.sqs.internal.SqsLargeMessageAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static class FailedProcessingLargePayloadException
    extends RuntimeException {
        public FailedProcessingLargePayloadException(String message, Throwable cause) {
            super(message, cause);
        }

        public FailedProcessingLargePayloadException(String message) {
            super(message);
        }
    }
}

