/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.sqs;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.lambda.powertools.core.internal.UserAgentConfigurator;
import software.amazon.lambda.powertools.sqs.SqsMessageHandler;
import software.amazon.lambda.powertools.sqs.exception.SkippedMessageDueToFailedBatchException;
import software.amazon.lambda.powertools.sqs.internal.BatchContext;
import software.amazon.lambda.powertools.sqs.internal.SqsLargeMessageAspect;
import software.amazon.payloadoffloading.PayloadS3Pointer;

@Deprecated
public final class SqsUtils {
    public static final String SQS = "sqs";
    private static final Logger LOG = LoggerFactory.getLogger(SqsUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String MESSAGE_GROUP_ID = "MessageGroupId";
    private static SqsClient client;
    private static S3Client s3Client;

    private SqsUtils() {
    }

    public static <R> R enrichedMessageFromS3(SQSEvent sqsEvent, Function<List<SQSEvent.SQSMessage>, R> messageFunction) {
        return SqsUtils.enrichedMessageFromS3(sqsEvent, true, messageFunction);
    }

    public static <R> R enrichedMessageFromS3(SQSEvent sqsEvent, boolean deleteS3Payload, Function<List<SQSEvent.SQSMessage>, R> messageFunction) {
        List<SQSEvent.SQSMessage> sqsMessages = sqsEvent.getRecords().stream().map(SqsUtils::clonedMessage).collect(Collectors.toList());
        List<PayloadS3Pointer> s3Pointers = SqsLargeMessageAspect.processMessages(sqsMessages);
        R returnValue = messageFunction.apply(sqsMessages);
        if (deleteS3Payload) {
            s3Pointers.forEach(SqsLargeMessageAspect::deleteMessage);
        }
        return returnValue;
    }

    public static void overrideSqsClient(SqsClient client) {
        SqsUtils.client = client;
    }

    public static void overrideS3Client(S3Client s3Client) {
        SqsUtils.s3Client = s3Client;
    }

    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, Class<? extends SqsMessageHandler<R>> handler) {
        return SqsUtils.batchProcessor(event, false, handler);
    }

    @SafeVarargs
    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, Class<? extends SqsMessageHandler<R>> handler, Class<? extends Exception> ... nonRetryableExceptions) {
        return SqsUtils.batchProcessor(event, false, handler, nonRetryableExceptions);
    }

    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, Class<? extends SqsMessageHandler<R>> handler) {
        SqsMessageHandler<R> handlerInstance = SqsUtils.instantiatedHandler(handler);
        return SqsUtils.batchProcessor(event, suppressException, handlerInstance);
    }

    @SafeVarargs
    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, Class<? extends SqsMessageHandler<R>> handler, Class<? extends Exception> ... nonRetryableExceptions) {
        SqsMessageHandler<R> handlerInstance = SqsUtils.instantiatedHandler(handler);
        return SqsUtils.batchProcessor(event, suppressException, handlerInstance, false, nonRetryableExceptions);
    }

    @SafeVarargs
    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, Class<? extends SqsMessageHandler<R>> handler, boolean deleteNonRetryableMessageFromQueue, Class<? extends Exception> ... nonRetryableExceptions) {
        SqsMessageHandler<R> handlerInstance = SqsUtils.instantiatedHandler(handler);
        return SqsUtils.batchProcessor(event, suppressException, handlerInstance, deleteNonRetryableMessageFromQueue, nonRetryableExceptions);
    }

    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, SqsMessageHandler<R> handler) {
        return SqsUtils.batchProcessor(event, false, handler);
    }

    @SafeVarargs
    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, SqsMessageHandler<R> handler, Class<? extends Exception> ... nonRetryableExceptions) {
        return SqsUtils.batchProcessor(event, false, handler, false, nonRetryableExceptions);
    }

    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, SqsMessageHandler<R> handler) {
        return SqsUtils.batchProcessor(event, suppressException, handler, false, new Class[0]);
    }

    @SafeVarargs
    @Deprecated
    public static <R> List<R> batchProcessor(SQSEvent event, boolean suppressException, SqsMessageHandler<R> handler, boolean deleteNonRetryableMessageFromQueue, Class<? extends Exception> ... nonRetryableExceptions) {
        ArrayList<R> handlerReturn = new ArrayList<R>();
        if (client == null) {
            client = (SqsClient)SqsClient.builder().overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)UserAgentConfigurator.getUserAgent((String)SQS)).build());
        }
        BatchContext batchContext = new BatchContext(client);
        int offset = 0;
        boolean failedBatch = false;
        while (offset < event.getRecords().size() && !failedBatch) {
            SQSEvent.SQSMessage message2 = (SQSEvent.SQSMessage)event.getRecords().get(offset);
            ++offset;
            try {
                handlerReturn.add(handler.process(message2));
                batchContext.addSuccess(message2);
            }
            catch (Exception e) {
                String messageGroupId;
                batchContext.addFailure(message2, e);
                String string = messageGroupId = message2.getAttributes() != null ? (String)message2.getAttributes().get(MESSAGE_GROUP_ID) : null;
                if (messageGroupId != null) {
                    LOG.info("A message in a message batch with messageGroupId {} and messageId {} failed; failing the rest of the batch too", (Object)messageGroupId, (Object)message2.getMessageId());
                    failedBatch = true;
                }
                LOG.error("Encountered issue processing message: {}", (Object)message2.getMessageId(), (Object)e);
            }
        }
        if (offset < event.getRecords().size()) {
            event.getRecords().subList(offset, event.getRecords().size()).forEach(message -> {
                LOG.info("Skipping message {} as another message with a message group failed in this batch", (Object)message.getMessageId());
                batchContext.addFailure((SQSEvent.SQSMessage)message, new SkippedMessageDueToFailedBatchException());
            });
        }
        batchContext.processSuccessAndHandleFailed(handlerReturn, suppressException, deleteNonRetryableMessageFromQueue, nonRetryableExceptions);
        return handlerReturn;
    }

    private static <R> SqsMessageHandler<R> instantiatedHandler(Class<? extends SqsMessageHandler<R>> handler) {
        try {
            if (handler.getDeclaringClass() == null) {
                return handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Constructor<SqsMessageHandler<R>> constructor = handler.getDeclaredConstructor(handler.getDeclaringClass());
            constructor.setAccessible(true);
            return constructor.newInstance(handler.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            LOG.error("Failed creating handler instance", (Throwable)e);
            throw new RuntimeException("Unexpected error occurred. Please raise issue at https://github.com/aws-powertools/powertools-lambda-java/issues", e);
        }
    }

    private static SQSEvent.SQSMessage clonedMessage(SQSEvent.SQSMessage sqsMessage) {
        try {
            return (SQSEvent.SQSMessage)objectMapper.readValue(objectMapper.writeValueAsString((Object)sqsMessage), SQSEvent.SQSMessage.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper objectMapper() {
        return objectMapper;
    }

    public static S3Client s3Client() {
        if (s3Client == null) {
            s3Client = (S3Client)S3Client.builder().overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)UserAgentConfigurator.getUserAgent((String)SQS)).build());
            s3Client = S3Client.create();
        }
        return s3Client;
    }
}

