/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.sqs;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SQSBatchProcessingException
extends RuntimeException {
    private final List<Exception> exceptions;
    private final List<SQSEvent.SQSMessage> failures;
    private final List<Object> returnValues;

    public <T> SQSBatchProcessingException(List<Exception> exceptions, List<SQSEvent.SQSMessage> failures, List<T> successReturns) {
        super(exceptions.stream().map(Throwable::toString).collect(Collectors.joining("\n")));
        this.exceptions = new ArrayList<Exception>(exceptions);
        this.failures = new ArrayList<SQSEvent.SQSMessage>(failures);
        this.returnValues = new ArrayList<T>(successReturns);
    }

    public List<Exception> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public List<Object> successMessageReturnValues() {
        return Collections.unmodifiableList(this.returnValues);
    }

    public List<SQSEvent.SQSMessage> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    @Override
    public void printStackTrace() {
        for (Exception exception : this.exceptions) {
            exception.printStackTrace();
        }
    }
}

