/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionRegistry;
import io.burt.jmespath.jackson.JacksonRuntime;
import software.amazon.lambda.powertools.validation.jmespath.Base64Function;
import software.amazon.lambda.powertools.validation.jmespath.Base64GZipFunction;

public class ValidationConfig {
    private static final ThreadLocal<ObjectMapper> om = ThreadLocal.withInitial(() -> {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    });
    private SpecVersion.VersionFlag jsonSchemaVersion = SpecVersion.VersionFlag.V7;
    private JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)this.jsonSchemaVersion);
    private final FunctionRegistry defaultFunctions = FunctionRegistry.defaultRegistry();
    private final FunctionRegistry customFunctions = this.defaultFunctions.extend(new Function[]{new Base64Function(), new Base64GZipFunction()});
    private final RuntimeConfiguration configuration = new RuntimeConfiguration.Builder().withFunctionRegistry(this.customFunctions).build();
    private JmesPath<JsonNode> jmesPath = new JacksonRuntime(this.configuration, this.getObjectMapper());

    private ValidationConfig() {
    }

    public static ValidationConfig get() {
        return ConfigHolder.instance;
    }

    public void setSchemaVersion(SpecVersion.VersionFlag version) {
        if (version != this.jsonSchemaVersion) {
            this.jsonSchemaVersion = version;
            this.factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)version);
        }
    }

    public SpecVersion.VersionFlag getSchemaVersion() {
        return this.jsonSchemaVersion;
    }

    public <T extends BaseFunction> void addFunction(T function) {
        FunctionRegistry functionRegistryWithExtendedFunctions = this.configuration.functionRegistry().extend(new Function[]{function});
        RuntimeConfiguration updatedConfig = new RuntimeConfiguration.Builder().withFunctionRegistry(functionRegistryWithExtendedFunctions).build();
        this.jmesPath = new JacksonRuntime(updatedConfig, this.getObjectMapper());
    }

    public JsonSchemaFactory getFactory() {
        return this.factory;
    }

    public JmesPath<JsonNode> getJmesPath() {
        return this.jmesPath;
    }

    public ObjectMapper getObjectMapper() {
        return om.get();
    }

    /* synthetic */ ValidationConfig(ValidationConfig validationConfig) {
        this();
    }

    private static class ConfigHolder {
        private static final ValidationConfig instance = new ValidationConfig(null);

        private ConfigHolder() {
        }
    }
}

