/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation.jmespath;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import software.amazon.lambda.powertools.validation.jmespath.Base64Function;

public class Base64GZipFunction
extends BaseFunction {
    public Base64GZipFunction() {
        super("powertools_base64_gzip", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING));
    }

    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        Object value = arguments.get(0).value();
        String encodedString = runtime.toString(value);
        String decompressString = Base64GZipFunction.decompress(Base64Function.decode(encodedString.getBytes(StandardCharsets.UTF_8)));
        return (T)runtime.createString(decompressString);
    }

    public static String decompress(byte[] compressed) {
        if (compressed == null || compressed.length == 0) {
            return "";
        }
        try {
            StringBuilder out = new StringBuilder();
            if (Base64GZipFunction.isCompressed(compressed)) {
                String line;
                GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(compressed));
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8));
                while ((line = bf.readLine()) != null) {
                    out.append(line);
                }
            } else {
                out.append(Arrays.toString(compressed));
            }
            return out.toString();
        }
        catch (IOException iOException) {
            return new String(compressed, StandardCharsets.UTF_8);
        }
    }

    public static boolean isCompressed(byte[] compressed) {
        return compressed[0] == 31 && compressed[1] == -117;
    }
}

