/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.crypto;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DependencyTimeoutException;
import com.amazonaws.services.kms.model.DisabledException;
import com.amazonaws.services.kms.model.InvalidGrantTokenException;
import com.amazonaws.services.kms.model.InvalidKeyUsageException;
import com.amazonaws.services.kms.model.KMSInternalException;
import com.amazonaws.services.kms.model.KMSInvalidStateException;
import com.amazonaws.services.kms.model.KeyUnavailableException;
import com.amazonaws.services.kms.model.MessageType;
import com.amazonaws.services.kms.model.NotFoundException;
import com.amazonaws.services.kms.model.SignRequest;
import com.amazonaws.services.kms.model.SignResult;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.aws.kms.crypto.impl.KmsAsymmetricRSASSAProvider;
import com.nimbusds.jose.aws.kms.exceptions.TemporaryJOSEException;
import com.nimbusds.jose.util.Base64URL;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
public class KmsAsymmetricRSASSASigner
extends KmsAsymmetricRSASSAProvider
implements JWSSigner {
    public KmsAsymmetricRSASSASigner(@NonNull AWSKMS kms, @NonNull String privateKeyId, @NonNull MessageType messageType) {
        super(kms, privateKeyId, messageType);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(privateKeyId, "privateKeyId is marked non-null but is null");
        Objects.requireNonNull(messageType, "messageType is marked non-null but is null");
    }

    public Base64URL sign(@NonNull JWSHeader header, @NonNull byte[] signingInput) throws JOSEException {
        SignResult signResult;
        Objects.requireNonNull(header, "header is marked non-null but is null");
        Objects.requireNonNull(signingInput, "signingInput is marked non-null but is null");
        ByteBuffer message = this.getMessage(header, signingInput);
        try {
            signResult = this.getKms().sign(new SignRequest().withKeyId(this.getPrivateKeyId()).withMessageType(this.getMessageType()).withMessage(message).withSigningAlgorithm(header.getAlgorithm().toString()));
        }
        catch (DisabledException | InvalidKeyUsageException | KMSInvalidStateException | KeyUnavailableException | NotFoundException e) {
            throw new RemoteKeySourceException("An exception was thrown from KMS due to invalid key.", e);
        }
        catch (DependencyTimeoutException | InvalidGrantTokenException | KMSInternalException e) {
            throw new TemporaryJOSEException("A temporary exception was thrown from KMS.", e);
        }
        return Base64URL.encode((byte[])signResult.getSignature().array());
    }
}

