/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.crypto;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DataKeySpec;
import com.amazonaws.services.kms.model.DependencyTimeoutException;
import com.amazonaws.services.kms.model.DisabledException;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import com.amazonaws.services.kms.model.InvalidGrantTokenException;
import com.amazonaws.services.kms.model.InvalidKeyUsageException;
import com.amazonaws.services.kms.model.KMSInternalException;
import com.amazonaws.services.kms.model.KMSInvalidStateException;
import com.amazonaws.services.kms.model.KeyUnavailableException;
import com.amazonaws.services.kms.model.NotFoundException;
import com.google.common.collect.ImmutableMap;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.aws.kms.crypto.impl.KmsSymmetricCryptoProvider;
import com.nimbusds.jose.aws.kms.exceptions.TemporaryJOSEException;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.jca.JWEJCAContext;
import com.nimbusds.jose.util.Base64URL;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

@ThreadSafe
public class KmsSymmetricEncrypter
extends KmsSymmetricCryptoProvider
implements JWEEncrypter {
    public KmsSymmetricEncrypter(@NonNull AWSKMS kms, @NonNull String keyId) {
        super(kms, keyId);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
    }

    public KmsSymmetricEncrypter(@NonNull AWSKMS kms, @NonNull String keyId, @NonNull Map<String, String> encryptionContext) {
        super(kms, keyId, encryptionContext);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
        Objects.requireNonNull(encryptionContext, "encryptionContext is marked non-null but is null");
    }

    public JWECryptoParts encrypt(@NonNull JWEHeader header, @NonNull byte[] clearText) throws JOSEException {
        Objects.requireNonNull(header, "header is marked non-null but is null");
        Objects.requireNonNull(clearText, "clearText is marked non-null but is null");
        this.validateJWEHeader(header);
        GenerateDataKeyResult generateDataKeyResult = this.generateDataKey(this.getKeyId(), header.getEncryptionMethod());
        SecretKeySpec cek = new SecretKeySpec(generateDataKeyResult.getPlaintext().array(), header.getAlgorithm().toString());
        Base64URL encryptedKey = Base64URL.encode((byte[])generateDataKeyResult.getCiphertextBlob().array());
        JWEHeader updatedHeader = Objects.nonNull(this.getEncryptionContext()) ? new JWEHeader.Builder(header).customParams((Map)ImmutableMap.of((Object)"ec", this.getEncryptionContext())).build() : header;
        return ContentCryptoProvider.encrypt((JWEHeader)updatedHeader, (byte[])clearText, (SecretKey)cek, (Base64URL)encryptedKey, (JWEJCAContext)this.getJCAContext());
    }

    private GenerateDataKeyResult generateDataKey(String keyId, EncryptionMethod encryptionMethod) throws JOSEException {
        try {
            return this.getKms().generateDataKey(new GenerateDataKeyRequest().withKeyId(keyId).withKeySpec((DataKeySpec)ENCRYPTION_METHOD_TO_DATA_KEY_SPEC_MAP.get(encryptionMethod)).withEncryptionContext(this.getEncryptionContext()));
        }
        catch (DisabledException | InvalidKeyUsageException | KMSInvalidStateException | KeyUnavailableException | NotFoundException e) {
            throw new RemoteKeySourceException("An exception was thrown from KMS due to invalid key.", e);
        }
        catch (DependencyTimeoutException | InvalidGrantTokenException | KMSInternalException e) {
            throw new TemporaryJOSEException("A temporary error was thrown from KMS.", e);
        }
    }
}

