/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.scripts;

import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.MessageType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.aws.kms.crypto.KmsAsymmetricRSASSASigner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class KmsAsymmetricJwsCompactSignatureGeneratorScript {
    private static final String COMMAND = "gradle kmsRsaSsaSigner";

    public static void main(String[] args) throws Exception {
        new KmsAsymmetricJwsCompactSignatureGeneratorScript().execute(args);
    }

    private void execute(String[] args) throws Exception {
        Options options = this.buildOptions();
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("help")) {
            System.out.println("\n***********************************************\n");
            new HelpFormatter().printHelp(COMMAND, options);
            System.out.println("\n***********************************************\n");
        } else if (!(cmd.hasOption("alg") && cmd.hasOption("kid") && cmd.hasOption("payload") && cmd.hasOption("messageType"))) {
            System.out.printf("%1$s%2$s, %3$s, %4$s, %5$s options are required. Use '--%6$s' for details of these options.%1$s", "\n***********************************************\n", "alg", "kid", "payload", "messageType", "help");
        } else {
            JWSObject jwsObject = this.sign(JWSAlgorithm.parse((String)cmd.getOptionValue("alg")), cmd.getOptionValue("kid"), cmd.getOptionValue("payload"), cmd.getOptionValue("messageType"));
            System.out.printf("%1$sJWS Token:%1$s%2$s%1$s", "\n***********************************************\n", jwsObject.serialize());
        }
    }

    private Options buildOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("help").desc("Print this help message.").build());
        options.addOption(Option.builder().hasArg().longOpt("alg").desc("JWS signature generation algorithm").build());
        options.addOption(Option.builder().hasArg().longOpt("kid").desc("Id of the key, which should used for signature generation. Pass a KMS CMK ARN or alias ARN. Note: You'll have to configure credentials of an IAM user in the default profile, who as access to the provided CMK. Follow these instruction to configure user credentials: https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html#cli-configure-files-where").build());
        options.addOption(Option.builder().hasArg().longOpt("messageType").desc("Type Of message can be Digest or rawhttps://docs.aws.amazon.com/kms/latest/APIReference/API_Sign.html#API_Sign_RequestSyntax").build());
        options.addOption(Option.builder().hasArg().longOpt("payload").desc("Payload to for signature generation.").build());
        return options;
    }

    private JWSObject sign(JWSAlgorithm alg, String kid, String payload, String messageType) throws Exception {
        KmsAsymmetricRSASSASigner jwsSigner = new KmsAsymmetricRSASSASigner(AWSKMSClientBuilder.defaultClient(), kid, MessageType.fromValue((String)messageType));
        JWSHeader jwsHeader = new JWSHeader.Builder(alg).keyID(kid).customParam("messageType", (Object)messageType).build();
        JWSObject jwsObject = new JWSObject(jwsHeader, new Payload(payload));
        jwsObject.sign((JWSSigner)jwsSigner);
        return jwsObject;
    }
}

