/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.scripts;

import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.aws.kms.crypto.KmsSymmetricDecrypter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class KmsSymmetricJweCompactDecrypterScript {
    private static final String COMMAND = "gradle kmsSymmetricJWEDecrypt";

    public static void main(String[] args) throws Exception {
        new KmsSymmetricJweCompactDecrypterScript().execute(args);
    }

    private void execute(String[] args) throws Exception {
        Options options = this.buildOptions();
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("help")) {
            System.out.println("\n***********************************************\n");
            new HelpFormatter().printHelp(COMMAND, options);
            System.out.println("\n***********************************************\n");
        } else if (!cmd.hasOption("jweToken")) {
            System.out.printf("%1$s%2$s option is required. Use '%3$s' for details of this option.%1$s", "\n***********************************************\n", "jweToken", "help");
        } else {
            JWEObject jweObject = this.decrypt(cmd.getOptionValue("jweToken"));
            System.out.printf("%1$sDECRYPTED TEXT :%1$s%2$s%1$s", "\n***********************************************\n", jweObject.getPayload());
        }
    }

    private Options buildOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("help").desc("Print this help message.").build());
        options.addOption(Option.builder().hasArg().longOpt("jweToken").desc("Serialized JWE token to decrypt.").build());
        return options;
    }

    private JWEObject decrypt(String serializedJwe) throws Exception {
        JWEObject jweObject = JWEObject.parse((String)serializedJwe);
        JWEHeader jweHeader = jweObject.getHeader();
        jweObject.decrypt((JWEDecrypter)new KmsSymmetricDecrypter(AWSKMSClientBuilder.defaultClient(), jweHeader.getKeyID()));
        return jweObject;
    }
}

