/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.crypto;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DependencyTimeoutException;
import com.amazonaws.services.kms.model.DisabledException;
import com.amazonaws.services.kms.model.InvalidGrantTokenException;
import com.amazonaws.services.kms.model.InvalidKeyUsageException;
import com.amazonaws.services.kms.model.KMSInternalException;
import com.amazonaws.services.kms.model.KMSInvalidSignatureException;
import com.amazonaws.services.kms.model.KMSInvalidStateException;
import com.amazonaws.services.kms.model.KeyUnavailableException;
import com.amazonaws.services.kms.model.MessageType;
import com.amazonaws.services.kms.model.NotFoundException;
import com.amazonaws.services.kms.model.VerifyRequest;
import com.amazonaws.services.kms.model.VerifyResult;
import com.nimbusds.jose.CriticalHeaderParamsAware;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.aws.kms.crypto.impl.KmsAsymmetricRSASSAProvider;
import com.nimbusds.jose.aws.kms.exceptions.TemporaryJOSEException;
import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.util.Base64URL;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
public class KmsAsymmetricRSASSAVerifier
extends KmsAsymmetricRSASSAProvider
implements JWSVerifier,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public KmsAsymmetricRSASSAVerifier(@NonNull AWSKMS kms, @NonNull String privateKeyId, @NonNull MessageType messageType) {
        super(kms, privateKeyId, messageType);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(privateKeyId, "privateKeyId is marked non-null but is null");
        Objects.requireNonNull(messageType, "messageType is marked non-null but is null");
    }

    public KmsAsymmetricRSASSAVerifier(@NonNull AWSKMS kms, @NonNull String privateKeyId, @NonNull MessageType messageType, @NonNull Set<String> defCritHeaders) {
        super(kms, privateKeyId, messageType);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(privateKeyId, "privateKeyId is marked non-null but is null");
        Objects.requireNonNull(messageType, "messageType is marked non-null but is null");
        Objects.requireNonNull(defCritHeaders, "defCritHeaders is marked non-null but is null");
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getDeferredCriticalHeaderParams();
    }

    public boolean verify(@NonNull JWSHeader header, @NonNull byte[] signedContent, @NonNull Base64URL signature) throws JOSEException {
        VerifyResult verifyResult;
        Objects.requireNonNull(header, "header is marked non-null but is null");
        Objects.requireNonNull(signedContent, "signedContent is marked non-null but is null");
        Objects.requireNonNull(signature, "signature is marked non-null but is null");
        if (!this.critPolicy.headerPasses((Header)header)) {
            return false;
        }
        ByteBuffer message = this.getMessage(header, signedContent);
        try {
            verifyResult = this.getKms().verify(new VerifyRequest().withKeyId(this.getPrivateKeyId()).withSigningAlgorithm(header.getAlgorithm().toString()).withMessageType(this.getMessageType()).withMessage(message).withSignature(ByteBuffer.wrap(signature.decode())));
        }
        catch (KMSInvalidSignatureException e) {
            return false;
        }
        catch (DisabledException | InvalidKeyUsageException | KMSInvalidStateException | KeyUnavailableException | NotFoundException e) {
            throw new RemoteKeySourceException("An exception was thrown from KMS due to invalid key.", e);
        }
        catch (DependencyTimeoutException | InvalidGrantTokenException | KMSInternalException e) {
            throw new TemporaryJOSEException("A temporary exception was thrown from KMS.", e);
        }
        return verifyResult.isSignatureValid();
    }
}

