/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.crypto.impl;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DataKeySpec;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.crypto.impl.PublicBaseJWEProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class KmsSymmetricCryptoProvider
extends PublicBaseJWEProvider {
    @NonNull
    private final AWSKMS kms;
    @NonNull
    private final String keyId;
    private Map<String, String> encryptionContext;
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS = ImmutableSet.of((Object)JWEAlgorithm.parse((String)EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT.toString()));
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS = ImmutableSet.of((Object)EncryptionMethod.A128CBC_HS256, (Object)EncryptionMethod.A256CBC_HS512, (Object)EncryptionMethod.A128GCM, (Object)EncryptionMethod.A256GCM);
    public static final Map<EncryptionMethod, DataKeySpec> ENCRYPTION_METHOD_TO_DATA_KEY_SPEC_MAP = ImmutableMap.builder().put((Object)EncryptionMethod.A256GCM, (Object)DataKeySpec.AES_256).put((Object)EncryptionMethod.A256CBC_HS512, (Object)DataKeySpec.AES_256).put((Object)EncryptionMethod.A128GCM, (Object)DataKeySpec.AES_128).put((Object)EncryptionMethod.A128CBC_HS256, (Object)DataKeySpec.AES_128).build();
    public static final String ENCRYPTION_CONTEXT_HEADER = "ec";

    protected KmsSymmetricCryptoProvider(@NonNull AWSKMS kms, @NonNull String keyId) {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
        this.kms = kms;
        this.keyId = keyId;
    }

    protected KmsSymmetricCryptoProvider(@NonNull AWSKMS kms, @NonNull String keyId, @NonNull Map<String, String> encryptionContext) {
        this(kms, keyId);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
        Objects.requireNonNull(encryptionContext, "encryptionContext is marked non-null but is null");
        this.encryptionContext = ImmutableMap.copyOf(encryptionContext);
    }

    protected void validateJWEHeader(@NonNull JWEHeader header) throws JOSEException {
        Objects.requireNonNull(header, "header is marked non-null but is null");
        JWEAlgorithm alg = header.getAlgorithm();
        EncryptionMethod enc = header.getEncryptionMethod();
        if (!SUPPORTED_ALGORITHMS.contains(alg)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)alg, SUPPORTED_ALGORITHMS));
        }
        if (!SUPPORTED_ENCRYPTION_METHODS.contains(enc)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod((EncryptionMethod)enc, SUPPORTED_ENCRYPTION_METHODS));
        }
    }

    @NonNull
    @Generated
    protected AWSKMS getKms() {
        return this.kms;
    }

    @NonNull
    @Generated
    protected String getKeyId() {
        return this.keyId;
    }

    @Generated
    protected Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }
}

