/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.scripts;

import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.MessageType;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.aws.kms.crypto.KmsAsymmetricRSASSAVerifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class KmsAsymmetricJwsCompactVerifierScript {
    private static final String COMMAND = "gradle kmsSymmetricJWSVerify";

    public static void main(String[] args) throws Exception {
        new KmsAsymmetricJwsCompactVerifierScript().execute(args);
    }

    private void execute(String[] args) throws Exception {
        Options options = this.buildOptions();
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("help")) {
            System.out.println("\n***********************************************\n");
            new HelpFormatter().printHelp(COMMAND, options);
            System.out.println("\n***********************************************\n");
        } else if (!cmd.hasOption("jwsToken")) {
            System.out.printf("%1$s%2$s option is required. Use '%3$s' for details of this option.%1$s", "\n***********************************************\n", "jwsToken", "help");
        } else {
            boolean verificationResult = this.verify(cmd.getOptionValue("jwsToken"), cmd.getOptionValue("messageType"), cmd.getOptionValue("defCritHeaders"));
            System.out.printf("%1$sVERIFYCATION STATUS :%1$s%2$s%1$s", "\n***********************************************\n", verificationResult ? "Verified" : "Not Verified");
        }
    }

    private Options buildOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("help").desc("Print this help message.").build());
        options.addOption(Option.builder().hasArg().longOpt("jwsToken").desc("Serialized JWS Token to Verify").build());
        options.addOption(Option.builder().hasArg().longOpt("messageType").desc("Type Of message can be Digest or rawhttps://docs.aws.amazon.com/kms/latest/APIReference/API_Sign.html#API_Sign_RequestSyntax").build());
        options.addOption(Option.builder().hasArg().longOpt("defCritHeaders").desc("Comma separated critical headers which needs to be deferred from verification.").build());
        return options;
    }

    private boolean verify(String serializedJws, String messageTypeString, String defCritHeadersString) throws Exception {
        JWSObject jwsObject = JWSObject.parse((String)serializedJws);
        MessageType messageType = MessageType.fromValue((String)(Objects.nonNull(messageTypeString) ? messageTypeString : jwsObject.getHeader().getCustomParam("messageType").toString()));
        Set<String> defCritHeaders = null;
        if (Objects.nonNull(defCritHeadersString)) {
            defCritHeaders = Arrays.stream(defCritHeadersString.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        return jwsObject.verify((JWSVerifier)(Objects.nonNull(defCritHeaders) ? new KmsAsymmetricRSASSAVerifier(AWSKMSClientBuilder.defaultClient(), jwsObject.getHeader().getKeyID(), messageType, defCritHeaders) : new KmsAsymmetricRSASSAVerifier(AWSKMSClientBuilder.defaultClient(), jwsObject.getHeader().getKeyID(), messageType)));
    }
}

