/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import lombok.NonNull;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.msk.auth.iam.internals.utils.RegionUtils;

public class AuthenticationRequestParams {
    private static final String VERSION_1 = "2020_10_22";
    private static final String SERVICE_SCOPE = "kafka-cluster";
    @NonNull
    private final String version;
    @NonNull
    private final String host;
    @NonNull
    private final AwsCredentials awsCredentials;
    @NonNull
    private final Region region;
    @NonNull
    private final String userAgent;

    public String getServiceScope() {
        return SERVICE_SCOPE;
    }

    public static AuthenticationRequestParams create(@NonNull String host, AwsCredentials credentials, @NonNull String userAgent) throws IllegalArgumentException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (userAgent == null) {
            throw new NullPointerException("userAgent is marked non-null but is null");
        }
        Region region = RegionUtils.extractRegionFromHost(host);
        if (region == null) {
            throw new IllegalArgumentException("Host " + host + " does not belong to a valid region.");
        }
        return new AuthenticationRequestParams(VERSION_1, host, credentials, region, userAgent);
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    @NonNull
    public AwsCredentials getAwsCredentials() {
        return this.awsCredentials;
    }

    @NonNull
    public Region getRegion() {
        return this.region;
    }

    @NonNull
    public String getUserAgent() {
        return this.userAgent;
    }

    private AuthenticationRequestParams(@NonNull String version, @NonNull String host, @NonNull AwsCredentials awsCredentials, @NonNull Region region, @NonNull String userAgent) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (awsCredentials == null) {
            throw new NullPointerException("awsCredentials is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (userAgent == null) {
            throw new NullPointerException("userAgent is marked non-null but is null");
        }
        this.version = version;
        this.host = host;
        this.awsCredentials = awsCredentials;
        this.region = region;
        this.userAgent = userAgent;
    }
}

