/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import software.amazon.neptune.cluster.NeptuneInstanceMetadata;

public class NeptuneClusterMetadata {
    private final Collection<NeptuneInstanceMetadata> instances = new ArrayList<NeptuneInstanceMetadata>();
    private String clusterEndpoint;
    private String readerEndpoint;

    public static NeptuneClusterMetadata fromByeArray(byte[] bytes) throws IOException {
        return (NeptuneClusterMetadata)new ObjectMapper().readerFor(NeptuneClusterMetadata.class).readValue(bytes);
    }

    public void setClusterEndpoint(String clusterEndpoint) {
        this.clusterEndpoint = clusterEndpoint;
    }

    public void setReaderEndpoint(String readerEndpoint) {
        this.readerEndpoint = readerEndpoint;
    }

    public void setInstances(Collection<NeptuneInstanceMetadata> instances) {
        this.instances.clear();
        this.instances.addAll(instances);
    }

    public NeptuneClusterMetadata withClusterEndpoint(String clusterEndpoint) {
        this.setClusterEndpoint(clusterEndpoint);
        return this;
    }

    public NeptuneClusterMetadata withReaderEndpoint(String readerEndpoint) {
        this.setReaderEndpoint(readerEndpoint);
        return this;
    }

    public NeptuneClusterMetadata withInstances(Collection<NeptuneInstanceMetadata> instances) {
        this.setInstances(instances);
        return this;
    }

    public Collection<NeptuneInstanceMetadata> getInstances() {
        return this.instances;
    }

    public String getClusterEndpoint() {
        return this.clusterEndpoint;
    }

    public String getReaderEndpoint() {
        return this.readerEndpoint;
    }

    public String toString() {
        return "NeptuneClusterMetadata{instances=" + this.instances + ", clusterEndpoint='" + this.clusterEndpoint + '\'' + ", readerEndpoint='" + this.readerEndpoint + '\'' + '}';
    }

    public String toJsonString() throws JsonProcessingException {
        return new ObjectMapper().writerFor(this.getClass()).writeValueAsString((Object)this);
    }
}

