/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.util.TimeOutUtils;

public class S3BasicFileAttributes
implements BasicFileAttributes {
    private final S3Path path;
    private final S3AsyncClient client;
    private final String bucketName;
    private final Set<String> methodNamesToFilterOut = Stream.of("wait", "toString", "hashCode", "getClass", "notify", "notifyAll").collect(Collectors.toSet());
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected S3BasicFileAttributes(S3Path path) {
        this(path, path.getFileSystem().client());
    }

    protected S3BasicFileAttributes(S3Path path, S3AsyncClient client) {
        this.path = path;
        this.client = client;
        this.bucketName = path.bucketName();
    }

    @Override
    public FileTime lastModifiedTime() {
        Instant lastModified;
        if (this.path.isDirectory()) {
            return FileTime.from(Instant.EPOCH);
        }
        try {
            lastModified = ((HeadObjectResponse)this.client.headObject(req -> req.bucket(this.bucketName).key(this.path.getKey())).get(1L, TimeUnit.MINUTES)).lastModified();
        }
        catch (ExecutionException e) {
            String errMsg = String.format("an '%s' error occurred while obtaining the last modified time of '%s' that was not handled successfully by the S3Client's configured RetryConditions", e.getCause().toString(), this.path.toUri());
            this.logger.error(errMsg);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "lastModifiedTime()", 1L, TimeUnit.MINUTES);
        }
        return FileTime.from(lastModified);
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastModifiedTime();
    }

    @Override
    public FileTime creationTime() {
        return this.lastModifiedTime();
    }

    @Override
    public boolean isRegularFile() {
        return !this.path.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.path.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() throws RuntimeException {
        if (this.isDirectory()) {
            return 0L;
        }
        try {
            return ((HeadObjectResponse)this.client.headObject(req -> req.bucket(this.bucketName).key(this.path.getKey())).get(1L, TimeUnit.MINUTES)).contentLength();
        }
        catch (ExecutionException e) {
            String errMsg = String.format("an '%s' error occurred while obtaining the size of '%s' that was not handled successfully by the S3Client's configured RetryConditions", e.getCause().toString(), this.path.toUri());
            this.logger.error(errMsg);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "size()", 1L, TimeUnit.MINUTES);
        }
    }

    @Override
    public Object fileKey() {
        if (this.path.isDirectory()) {
            return null;
        }
        try {
            return ((HeadObjectResponse)this.client.headObject(req -> req.bucket(this.bucketName).key(this.path.toString())).get(1L, TimeUnit.MINUTES)).eTag();
        }
        catch (ExecutionException e) {
            String errMsg = String.format("an '%s' error occurred while obtaining the file key of '%s' that was not handled successfully by the S3Client's configured RetryConditions", e.getCause().toString(), this.path.toUri());
            this.logger.error(errMsg);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "size()", 1L, TimeUnit.MINUTES);
        }
    }

    protected Map<String, Object> asMap() {
        return this.asMap(x -> true);
    }

    protected Map<String, Object> asMap(Predicate<String> attributeFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Arrays.stream(this.getClass().getMethods()).filter(method -> method.getParameterCount() == 0).filter(method -> !this.methodNamesToFilterOut.contains(method.getName())).filter(method -> attributeFilter.test(method.getName())).forEach(method -> {
            this.logger.debug("method name: '{}'", (Object)method.getName());
            try {
                map.put(method.getName(), method.invoke((Object)this, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String errorMsg = String.format("an exception has occurred during a reflection operation on the methods of the file attributes of '%s', check if your Java SecurityManager is configured to allow reflection.", this.path.toUri());
                this.logger.error("{}, caused by {}", (Object)errorMsg, (Object)e.getCause().getMessage());
                throw new RuntimeException(errorMsg, e);
            }
        });
        return map;
    }
}

