/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.exception.ApiCallAttemptTimeoutException;
import software.amazon.awssdk.core.exception.ApiCallTimeoutException;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnClockSkewCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnStatusCodeCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnThrottlingCondition;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;
import software.amazon.nio.spi.s3.util.StringUtils;

public class S3ClientProvider {
    protected S3CrtAsyncClientBuilder asyncClientBuilder = S3AsyncClient.crtBuilder();
    protected final S3NioSpiConfiguration configuration;
    private static final S3Client DEFAULT_CLIENT = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(URI.create("https://s3.us-east-1.amazonaws.com"))).region(Region.US_EAST_1)).build();
    private static final S3AsyncClient DEFAULT_ASYNC_CLIENT = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().endpointOverride(URI.create("https://s3.us-east-1.amazonaws.com"))).region(Region.US_EAST_1)).build();
    private final EqualJitterBackoffStrategy backoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(200L)).maxBackoffTime(Duration.ofSeconds(5L)).build();
    final RetryCondition retryCondition;
    Logger logger;

    public S3ClientProvider(S3NioSpiConfiguration c) {
        Set RETRYABLE_STATUS_CODES = Stream.of(500, 502, 503, 504).collect(Collectors.toSet());
        Set RETRYABLE_EXCEPTIONS = Stream.of(RetryableException.class, IOException.class, ApiCallAttemptTimeoutException.class, ApiCallTimeoutException.class).collect(Collectors.toSet());
        this.retryCondition = OrRetryCondition.create((RetryCondition[])new RetryCondition[]{RetryOnStatusCodeCondition.create(RETRYABLE_STATUS_CODES), RetryOnExceptionsCondition.create(RETRYABLE_EXCEPTIONS), RetryOnClockSkewCondition.create(), RetryOnThrottlingCondition.create()});
        this.logger = LoggerFactory.getLogger((String)"S3ClientStoreProvider");
        this.configuration = c == null ? new S3NioSpiConfiguration() : c;
    }

    public S3ClientProvider() {
        this(null);
    }

    public S3CrtAsyncClientBuilder asyncClientBuilder() {
        return this.asyncClientBuilder;
    }

    public void asyncClientBuilder(S3CrtAsyncClientBuilder builder) {
        this.asyncClientBuilder = builder;
    }

    public S3Client universalClient() {
        return (S3Client)this.universalClient(false);
    }

    public <T extends AwsClient> T universalClient(boolean async) {
        return (T)(async ? DEFAULT_ASYNC_CLIENT : DEFAULT_CLIENT);
    }

    protected S3Client generateClient(String bucketName) {
        return this.generateClient(bucketName, this.universalClient());
    }

    protected S3AsyncClient generateAsyncClient(String bucket) {
        return this.generateAsyncClient(bucket, this.universalClient());
    }

    protected S3Client generateClient(String bucketName, S3Client locationClient) {
        this.logger.debug("generating client for bucket: '{}'", (Object)bucketName);
        S3Client bucketSpecificClient = null;
        if (this.configuration.getEndpoint() == null || StringUtils.isBlank(this.configuration.getEndpoint())) {
            block7: {
                String bucketLocation = null;
                try {
                    this.logger.debug("determining bucket location with getBucketLocation");
                    bucketLocation = locationClient.getBucketLocation(builder -> builder.bucket(bucketName)).locationConstraintAsString();
                    bucketSpecificClient = this.clientForRegion(bucketLocation);
                }
                catch (S3Exception e) {
                    if (e.statusCode() == 403) {
                        this.logger.debug("Cannot determine location of '{}' bucket directly. Attempting to obtain bucket location with headBucket operation", (Object)bucketName);
                        try {
                            HeadBucketResponse headBucketResponse = locationClient.headBucket(builder -> builder.bucket(bucketName));
                            bucketSpecificClient = this.clientForRegion((String)headBucketResponse.sdkHttpResponse().firstMatchingHeader("x-amz-bucket-region").orElseThrow(() -> new NoSuchElementException("Head Bucket Response doesn't include the header 'x-amz-bucket-region'")));
                        }
                        catch (S3Exception e2) {
                            if (e2.statusCode() == 301) {
                                bucketSpecificClient = this.clientForRegion((String)e2.awsErrorDetails().sdkHttpResponse().firstMatchingHeader("x-amz-bucket-region").orElseThrow(() -> new NoSuchElementException("Head Bucket Response doesn't include the header 'x-amz-bucket-region'")));
                                break block7;
                            }
                            throw e2;
                        }
                    }
                    throw e;
                }
            }
            this.logger.warn("Unable to determine the region of bucket: '{}'. Generating a client for the profile region.", (Object)bucketName);
        }
        return bucketSpecificClient != null ? bucketSpecificClient : this.clientForRegion(this.configuration.getRegion());
    }

    protected S3AsyncClient generateAsyncClient(String bucketName, S3Client locationClient) {
        this.logger.debug("generating asynchronous client for bucket: '{}'", (Object)bucketName);
        S3AsyncClient bucketSpecificClient = null;
        if (this.configuration.getEndpoint() == null || StringUtils.isBlank(this.configuration.getEndpoint())) {
            block7: {
                String bucketLocation = null;
                try {
                    this.logger.debug("determining bucket location with getBucketLocation");
                    bucketLocation = locationClient.getBucketLocation(builder -> builder.bucket(bucketName)).locationConstraintAsString();
                    bucketSpecificClient = this.asyncClientForRegion(bucketLocation);
                }
                catch (S3Exception e) {
                    if (e.statusCode() == 403) {
                        this.logger.debug("Cannot determine location of '{}' bucket directly. Attempting to obtain bucket location with headBucket operation", (Object)bucketName);
                        try {
                            HeadBucketResponse headBucketResponse = locationClient.headBucket(builder -> builder.bucket(bucketName));
                            bucketSpecificClient = this.asyncClientForRegion((String)headBucketResponse.sdkHttpResponse().firstMatchingHeader("x-amz-bucket-region").orElseThrow(() -> new NoSuchElementException("Head Bucket Response doesn't include the header 'x-amz-bucket-region'")));
                        }
                        catch (S3Exception e2) {
                            if (e2.statusCode() == 301) {
                                bucketSpecificClient = this.asyncClientForRegion((String)e2.awsErrorDetails().sdkHttpResponse().firstMatchingHeader("x-amz-bucket-region").orElseThrow(() -> new NoSuchElementException("Head Bucket Response doesn't include the header 'x-amz-bucket-region'")));
                                break block7;
                            }
                            throw e2;
                        }
                    }
                    throw e;
                }
            }
            this.logger.warn("Unable to determine the region of bucket: '{}'. Generating a client for the profile region.", (Object)bucketName);
        }
        return bucketSpecificClient != null ? bucketSpecificClient : this.asyncClientForRegion(this.configuration.getRegion());
    }

    private S3Client clientForRegion(String regionName) {
        String endpoint = this.configuration.getEndpoint();
        AwsCredentials credentials = this.configuration.getCredentials();
        Region region = regionName == null || regionName.trim().isEmpty() ? Region.US_EAST_1 : Region.of((String)regionName);
        this.logger.debug("bucket region is: '{}'", (Object)region.id());
        S3ClientBuilder clientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().forcePathStyle(Boolean.valueOf(this.configuration.getForcePathStyle()))).region(region)).overrideConfiguration(conf -> conf.retryPolicy(builder -> builder.retryCondition(this.retryCondition).backoffStrategy((BackoffStrategy)this.backoffStrategy)));
        if (!StringUtils.isBlank(endpoint)) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getEndpointProtocol() + "://" + endpoint));
        }
        if (credentials != null) {
            clientBuilder.credentialsProvider(() -> credentials);
        }
        return (S3Client)clientBuilder.build();
    }

    private S3AsyncClient asyncClientForRegion(String regionName) {
        String endpoint = this.configuration.getEndpoint();
        AwsCredentials credentials = this.configuration.getCredentials();
        Region region = regionName == null || regionName.trim().isEmpty() ? Region.US_EAST_1 : Region.of((String)regionName);
        this.logger.debug("bucket region is: '{}'", (Object)region.id());
        if (!StringUtils.isBlank(endpoint)) {
            this.asyncClientBuilder.endpointOverride(URI.create(this.configuration.getEndpointProtocol() + "://" + endpoint));
        }
        if (credentials != null) {
            this.asyncClientBuilder.credentialsProvider(() -> credentials);
        }
        return this.asyncClientBuilder.forcePathStyle(Boolean.valueOf(this.configuration.getForcePathStyle())).region(region).build();
    }
}

