/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3SeekableByteChannel;

public class S3DirectReadableByteChannel
implements ReadableByteChannel {
    private final S3Client client;
    private final S3Path path;
    private final S3SeekableByteChannel delegator;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public S3DirectReadableByteChannel(S3Path path, S3Client client, S3SeekableByteChannel delegator) {
        this.path = path;
        this.client = client;
        this.delegator = delegator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        String key = this.path.getKey();
        Objects.requireNonNull(dst, "The destination byte buffer of a read operation may not be null");
        S3DirectReadableByteChannel s3DirectReadableByteChannel = this;
        synchronized (s3DirectReadableByteChannel) {
            this.logger.debug("channel position: {} of {}", (Object)this.delegator.position(), (Object)key);
            long size = this.delegator.size();
            this.logger.debug("{} size: {}", (Object)key, (Object)size);
            if (this.delegator.position() >= size) {
                this.logger.debug("completed reading from {}", (Object)key);
                return -1;
            }
            this.logger.debug("buffer position = {}, buffer limit = {}, buffer remaining: {}", new Object[]{dst.position(), dst.limit(), dst.remaining()});
            long readTo = Math.min((long)(dst.limit() - dst.position()), size - this.delegator.position()) - 1L;
            String range = "bytes=" + this.delegator.position() + "-" + (this.delegator.position() + readTo);
            this.logger.debug("byte range for {} is '{}'", (Object)key, (Object)range);
            ResponseBytes responseBytes = this.client.getObjectAsBytes(builder -> builder.bucket(this.path.bucketName()).key(this.path.getKey()).range(range));
            byte[] s3Bytes = responseBytes.asByteArray();
            this.logger.debug("read {} bytes from {}", (Object)s3Bytes.length, (Object)key);
            this.delegator.position(this.delegator.position() + (long)s3Bytes.length);
            this.logger.debug("new position of {} is: {}", (Object)key, (Object)this.delegator.position());
            int amountToWrite = Math.min(s3Bytes.length, dst.remaining());
            this.logger.debug("amount to write to buffer: {}, buffer remaining: {}", (Object)amountToWrite, (Object)dst.remaining());
            dst.put(s3Bytes, 0, amountToWrite);
            this.logger.debug("new buffer position is {}", (Object)dst.position());
            return s3Bytes.length;
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }
}

