/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.nio.spi.s3.FixedS3ClientProvider;
import software.amazon.nio.spi.s3.S3BasicFileAttributes;
import software.amazon.nio.spi.s3.S3FileAttributeView;
import software.amazon.nio.spi.s3.S3FileSystem;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3SeekableByteChannel;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;
import software.amazon.nio.spi.s3.util.S3FileSystemInfo;
import software.amazon.nio.spi.s3.util.TimeOutUtils;

public class S3FileSystemProvider
extends FileSystemProvider {
    public static final String SCHEME = "s3";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private static Map<String, S3FileSystem> cache = new HashMap<String, S3FileSystem>();

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public S3FileSystem newFileSystem(URI uri, Map<String, ?> env) throws FileSystemAlreadyExistsException {
        if (uri == null) {
            throw new IllegalArgumentException("uri can not be null");
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException(String.format("invalid uri '%s', please provide an uri as s3://bucket", uri.toString()));
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException(String.format("invalid uri '%s', please provide an uri as s3://bucket", uri.toString()));
        }
        S3FileSystem fs = null;
        S3FileSystemInfo info = this.fileSystemInfo(uri);
        if (cache.containsKey(info.key())) {
            throw new FileSystemAlreadyExistsException("a file system already exists for '" + info.key() + "', use getFileSystem() instead");
        }
        S3NioSpiConfiguration config = new S3NioSpiConfiguration(env).withEndpoint(info.endpoint()).withBucketName(info.bucket());
        if (info.accessKey() != null) {
            config.withCredentials(info.accessKey(), info.accessSecret());
        }
        fs = new S3FileSystem(this, config);
        cache.put(info.key(), fs);
        return fs;
    }

    public S3FileSystem newFileSystem(URI uri) {
        return this.newFileSystem(uri, Collections.EMPTY_MAP);
    }

    @Override
    public S3FileSystem getFileSystem(URI uri) {
        return this.getFileSystem(uri, false);
    }

    protected S3FileSystem getFileSystem(URI uri, boolean create) {
        S3FileSystemInfo info = this.fileSystemInfo(uri);
        S3FileSystem fs = cache.get(info.key());
        if (fs == null) {
            if (!create) {
                throw new FileSystemNotFoundException("file system not found for '" + info.key() + "'");
            }
            fs = this.newFileSystem(uri);
        }
        return fs;
    }

    public void closeFileSystem(FileSystem fs) {
        for (String key : cache.keySet()) {
            if (fs != cache.get(key)) continue;
            cache.remove(key);
            return;
        }
    }

    @Override
    public S3Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Objects.requireNonNull(uri);
        return this.getFileSystem(uri, true).getPath(uri.getScheme() + ":/" + uri.getPath(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (Objects.isNull(options)) {
            options = Collections.emptySet();
        }
        S3Path s3Path = (S3Path)path;
        S3FileSystem fs = s3Path.getFileSystem();
        S3SeekableByteChannel channel = new S3SeekableByteChannel(s3Path, fs.client(), options);
        fs.registerOpenChannel(channel);
        return channel;
    }

    @Deprecated
    protected SeekableByteChannel newByteChannel(S3AsyncClient client, Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newByteChannel(null, path, options, attrs);
    }

    @Deprecated
    protected DirectoryStream<Path> newDirectoryStream(S3AsyncClient s3Client, Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException, ExecutionException, InterruptedException {
        return this.newDirectoryStream(dir, filter);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        S3Path s3Path = (S3Path)dir;
        String dirName = s3Path.toAbsolutePath().getKey();
        if (!s3Path.isDirectory()) {
            dirName = dirName + "/";
        }
        String bucketName = s3Path.bucketName();
        S3FileSystem fs = s3Path.getFileSystem();
        String finalDirName = dirName;
        ListObjectsV2Publisher listObjectsV2Publisher = fs.client().listObjectsV2Paginator(req -> req.bucket(bucketName).prefix(finalDirName).delimiter("/"));
        final Iterator<Path> iterator = this.pathIteratorForPublisher(filter, fs, finalDirName, listObjectsV2Publisher);
        return new DirectoryStream<Path>(){

            @Override
            public void close() {
            }

            @Override
            public Iterator<Path> iterator() {
                return iterator;
            }
        };
    }

    private Iterator<Path> pathIteratorForPublisher(DirectoryStream.Filter<? super Path> filter, FileSystem fs, String finalDirName, ListObjectsV2Publisher listObjectsV2Publisher) {
        return Flowable.fromPublisher((Publisher)listObjectsV2Publisher).flatMapIterable(response -> {
            List items = response.commonPrefixes().stream().map(CommonPrefix::prefix).collect(Collectors.toList());
            items.addAll(response.contents().stream().map(S3Object::key).collect(Collectors.toList()));
            return items.stream().filter(p -> !((S3Path)fs.getPath((String)p, new String[0])).getKey().equals(finalDirName)).map(x$0 -> fs.getPath((String)x$0, new String[0])).filter(path -> {
                try {
                    return filter.accept((Path)path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }).collect(Collectors.toList());
        }).blockingStream().map(Path.class::cast).iterator();
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3FileSystem fs = ((S3Path)dir).getFileSystem();
        try {
            String directoryKey = ((S3Path)dir).toRealPath(LinkOption.NOFOLLOW_LINKS).getKey();
            if (!directoryKey.endsWith("/") && !directoryKey.isEmpty()) {
                directoryKey = directoryKey + "/";
            }
            long timeOut = 1L;
            TimeUnit unit = TimeUnit.MINUTES;
            try {
                fs.client().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(fs.bucketName()).key(directoryKey).build(), AsyncRequestBody.empty()).get(timeOut, unit);
            }
            catch (TimeoutException e) {
                throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "createDirectory", timeOut, unit);
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void createDirectory(S3AsyncClient s3Client, Path dir, FileAttribute<?> ... attrs) throws IOException, ExecutionException, InterruptedException {
        this.createDirectory(this.forceAwsClient(dir, s3Client), attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        S3FileSystem fs = ((S3Path)path).getFileSystem();
        try {
            S3Path s3Path = (S3Path)path;
            S3AsyncClient s3Client = fs.client();
            String bucketName = fs.bucketName();
            String prefix = s3Path.toRealPath(LinkOption.NOFOLLOW_LINKS).getKey();
            long timeOut = 1L;
            TimeUnit unit = TimeUnit.MINUTES;
            try {
                List<List<ObjectIdentifier>> keys = S3FileSystemProvider.getContainedObjectBatches(s3Client, bucketName, prefix, timeOut, unit);
                for (List<ObjectIdentifier> keyList : keys) {
                    s3Client.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(keyList).build()).build()).get(timeOut, unit);
                }
            }
            catch (TimeoutException e) {
                throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "delete", timeOut, unit);
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void delete(S3AsyncClient s3Client, Path path) throws IOException, ExecutionException, InterruptedException {
        this.delete(this.forceAwsClient(path, s3Client));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        try {
            if (source.equals(target)) {
                return;
            }
            List<CopyOption> copyOptions = Arrays.asList(options);
            S3Path s3SourcePath = (S3Path)source;
            S3Path s3TargetPath = (S3Path)target;
            S3FileSystem fs = ((S3Path)source).getFileSystem();
            S3AsyncClient s3Client = fs.client();
            String bucketName = fs.bucketName();
            String prefix = s3SourcePath.toRealPath(LinkOption.NOFOLLOW_LINKS).getKey();
            long timeOut = 1L;
            TimeUnit unit = TimeUnit.MINUTES;
            try {
                List<List<ObjectIdentifier>> keys = S3FileSystemProvider.getContainedObjectBatches(s3Client, bucketName, prefix, timeOut, unit);
                for (List<ObjectIdentifier> keyList : keys) {
                    for (ObjectIdentifier objectIdentifier : keyList) {
                        S3Path resolvedS3TargetPath = s3TargetPath.resolve(objectIdentifier.key().replaceFirst(prefix + "/", ""));
                        if (!copyOptions.contains(StandardCopyOption.REPLACE_EXISTING) && this.exists(s3Client, resolvedS3TargetPath)) {
                            throw new FileAlreadyExistsException("File already exists at the target key");
                        }
                        S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(s3Client).build();
                        try {
                            s3TransferManager.copy(CopyRequest.builder().copyObjectRequest((CopyObjectRequest)CopyObjectRequest.builder().checksumAlgorithm(ChecksumAlgorithm.SHA256).sourceBucket(bucketName).sourceKey(objectIdentifier.key()).destinationBucket(resolvedS3TargetPath.bucketName()).destinationKey(resolvedS3TargetPath.getKey()).build()).build()).completionFuture().get(timeOut, unit);
                        }
                        finally {
                            if (s3TransferManager == null) continue;
                            s3TransferManager.close();
                        }
                    }
                }
            }
            catch (TimeoutException e) {
                throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "copy", timeOut, unit);
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void copy(S3AsyncClient s3Client, Path source, Path target, CopyOption ... options) throws IOException, ExecutionException, InterruptedException {
        this.copy(this.forceAwsClient((S3Path)source, s3Client), target, options);
    }

    protected boolean exists(S3AsyncClient s3Client, S3Path path) throws InterruptedException, TimeoutException {
        try {
            s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.bucketName()).key(path.getKey()).build()).get(1L, TimeUnit.MINUTES);
            return true;
        }
        catch (ExecutionException | NoSuchKeyException e) {
            this.logger.debug("Could not retrieve object head information", e);
            return false;
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.copy(source, target, options);
        this.delete(source);
    }

    @Deprecated
    protected void move(S3AsyncClient s3Client, Path source, Path target, CopyOption ... options) throws IOException, ExecutionException, InterruptedException {
        this.move(this.forceAwsClient(source, s3Client), target, options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.toRealPath(LinkOption.NOFOLLOW_LINKS).equals(path2.toRealPath(LinkOption.NOFOLLOW_LINKS));
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        try {
            assert (path instanceof S3Path);
            S3Path s3Path = (S3Path)path.toRealPath(LinkOption.NOFOLLOW_LINKS);
            S3FileSystem fs = s3Path.getFileSystem();
            String bucketName = fs.bucketName();
            S3AsyncClient s3Client = fs.client();
            CompletableFuture response = s3Path.equals(s3Path.getRoot()) ? s3Client.headBucket(request -> request.bucket(bucketName)) : s3Client.headObject(req -> req.bucket(bucketName).key(s3Path.getKey()));
            long timeOut = 1L;
            TimeUnit unit = TimeUnit.MINUTES;
            try {
                SdkHttpResponse httpResponse = ((S3Response)response.get(timeOut, unit)).sdkHttpResponse();
                if (httpResponse.isSuccessful()) {
                    return;
                }
                if (httpResponse.statusCode() == 403) {
                    throw new AccessDeniedException(s3Path.toString());
                }
                if (httpResponse.statusCode() == 404) {
                    throw new NoSuchFileException(s3Path.toString());
                }
                throw new IOException(String.format("exception occurred while checking access, response code was '%d'", httpResponse.statusCode()));
            }
            catch (TimeoutException e) {
                throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "checkAccess", timeOut, unit);
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void checkAccess(S3AsyncClient s3Client, Path path, AccessMode ... modes) throws IOException, ExecutionException, InterruptedException {
        this.checkAccess(this.forceAwsClient(path, s3Client), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Objects.requireNonNull(path, "cannot obtain attributes for a null path");
        Objects.requireNonNull(type, "the type of attribute view required cannot be null");
        if (!(path instanceof S3Path)) {
            throw new IllegalArgumentException("path must be an S3 Path");
        }
        S3Path s3Path = (S3Path)path;
        if (type.equals(BasicFileAttributeView.class) || type.equals(S3FileAttributeView.class)) {
            S3FileAttributeView v = new S3FileAttributeView(s3Path);
            return (V)v;
        }
        throw new IllegalArgumentException("type must be BasicFileAttributeView.class or S3FileAttributeView.class");
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(type);
        if (!(path instanceof S3Path)) {
            throw new IllegalArgumentException("path must be an S3Path instance");
        }
        S3Path s3Path = (S3Path)path;
        S3AsyncClient s3Client = s3Path.getFileSystem().client();
        if (type.equals(BasicFileAttributes.class) || type.equals(S3BasicFileAttributes.class)) {
            S3BasicFileAttributes a = new S3BasicFileAttributes(s3Path, s3Client);
            return (A)a;
        }
        throw new UnsupportedOperationException("cannot read attributes of type: " + type);
    }

    @Deprecated
    protected <A extends BasicFileAttributes> A readAttributes(S3AsyncClient s3AsyncClient, Path path, Class<A> type, LinkOption ... options) {
        return this.readAttributes((Path)this.forceAwsClient(path, s3AsyncClient), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(attributes);
        S3Path s3Path = (S3Path)path;
        S3AsyncClient s3Client = s3Path.getFileSystem().client();
        if (s3Path.isDirectory() || attributes.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        if (attributes.equals("*") || attributes.equals(SCHEME)) {
            return new S3BasicFileAttributes(s3Path, s3Client).asMap();
        }
        Set attrSet = Arrays.stream(attributes.split(",")).map(attr -> attr.replaceAll("^s3:", "")).collect(Collectors.toSet());
        return this.readAttributes(path, S3BasicFileAttributes.class, options).asMap(attrSet::contains);
    }

    @Deprecated
    protected void readAttributes(S3AsyncClient client, Path path, String attributes, LinkOption ... options) {
        this.readAttributes((Path)this.forceAwsClient(path, client), attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("s3 file attributes cannot be modified by this class");
    }

    protected S3FileSystemInfo fileSystemInfo(URI uri) {
        return new S3FileSystemInfo(uri);
    }

    private static List<List<ObjectIdentifier>> getContainedObjectBatches(S3AsyncClient s3Client, String bucketName, String prefix, long timeOut, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        String continuationToken = null;
        boolean hasMoreItems = true;
        ArrayList<List<ObjectIdentifier>> keys = new ArrayList<List<ObjectIdentifier>>();
        while (hasMoreItems) {
            String finalContinuationToken = continuationToken;
            ListObjectsV2Response response = (ListObjectsV2Response)s3Client.listObjectsV2(req -> req.bucket(bucketName).prefix(prefix).continuationToken(finalContinuationToken)).get(timeOut, unit);
            List objects = response.contents().stream().filter(s3Object -> s3Object.key().equals(prefix) || s3Object.key().startsWith(prefix + "/")).map(s3Object -> (ObjectIdentifier)ObjectIdentifier.builder().key(s3Object.key()).build()).collect(Collectors.toList());
            if (!objects.isEmpty()) {
                keys.add(objects);
            }
            hasMoreItems = response.isTruncated();
            continuationToken = response.nextContinuationToken();
        }
        return keys;
    }

    private S3Path forceAwsClient(Path path, S3AsyncClient client) {
        S3Path p = (S3Path)path;
        p.getFileSystem().clientProvider(new FixedS3ClientProvider(client));
        return p;
    }
}

