/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.nio.spi.s3.PosixLikePathRepresentation;
import software.amazon.nio.spi.s3.S3FileSystem;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;

public class S3Path
implements Path {
    public static final String PATH_SEPARATOR = "/";
    private final S3FileSystem fileSystem;
    private final PosixLikePathRepresentation pathRepresentation;

    private S3Path(S3FileSystem fileSystem, PosixLikePathRepresentation pathRepresentation) {
        this.fileSystem = fileSystem;
        this.pathRepresentation = pathRepresentation;
    }

    private S3Path from(String path) {
        return S3Path.getPath(this.fileSystem, path, new String[0]);
    }

    public static S3Path getPath(S3FileSystem fs, S3Object s3Object) {
        return S3Path.getPath(fs, s3Object.key(), new String[0]);
    }

    public static S3Path getPath(S3FileSystem fsForBucket, String first, String ... more) {
        if (fsForBucket == null) {
            throw new IllegalArgumentException("The S3FileSystem may not be null");
        }
        if (first == null) {
            throw new IllegalArgumentException("first element of the path may not be null");
        }
        S3NioSpiConfiguration configuration = fsForBucket.configuration();
        if ((first = first.trim()).isEmpty() && more != null && more.length != 0) {
            throw new IllegalArgumentException("The first element of the path may not be empty when more exists");
        }
        if (first.startsWith(fsForBucket.provider().getScheme() + ":/")) {
            first = first.substring(fsForBucket.provider().getScheme().length() + 2);
            String part = null;
            if (configuration.getCredentials() != null) {
                AwsCredentials credentials = configuration.getCredentials();
                part = credentials.accessKeyId() + ':' + credentials.secretAccessKey();
                if (first.startsWith('/' + part)) {
                    first = PATH_SEPARATOR + first.substring(part.length() + 2);
                }
            }
            if (!(part = configuration.getEndpoint()).isEmpty() && first.startsWith(PATH_SEPARATOR + part)) {
                first = first.substring(part.length() + 1);
            }
            part = configuration.getBucketName();
            if (first.startsWith(PATH_SEPARATOR + part)) {
                first = first.substring(part.length() + 1);
            }
        }
        return new S3Path(fsForBucket, PosixLikePathRepresentation.of(first, more));
    }

    @Override
    public S3FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String bucketName() {
        return this.fileSystem.bucketName();
    }

    @Override
    public boolean isAbsolute() {
        return this.pathRepresentation.isAbsolute();
    }

    public boolean isDirectory() {
        return this.pathRepresentation.isDirectory();
    }

    @Override
    public S3Path getRoot() {
        return this.isAbsolute() ? new S3Path(this.fileSystem, PosixLikePathRepresentation.ROOT) : null;
    }

    @Override
    public S3Path getFileName() {
        List<String> elements = this.pathRepresentation.elements();
        int size = elements.size();
        if (size == 0) {
            return null;
        }
        if (this.pathRepresentation.hasTrailingSeparator()) {
            return this.from(elements.get(size - 1) + PATH_SEPARATOR);
        }
        return this.from(elements.get(size - 1));
    }

    @Override
    public S3Path getParent() {
        int size = this.pathRepresentation.elements().size();
        if (this.equals(this.getRoot()) || size < 1) {
            return null;
        }
        if (this.pathRepresentation.isAbsolute() && size == 1) {
            return this.getRoot();
        }
        return this.subpath(0, this.getNameCount() - 1);
    }

    @Override
    public int getNameCount() {
        return this.pathRepresentation.elements().size();
    }

    @Override
    public S3Path getName(int index) {
        List<String> elements = this.pathRepresentation.elements();
        if (index < 0 || index >= elements.size()) {
            throw new IllegalArgumentException("index must be >= 0 and <= the number of path elements");
        }
        return this.subpath(index, index + 1);
    }

    @Override
    public S3Path subpath(int beginIndex, int endIndex) {
        int size = this.pathRepresentation.elements().size();
        if (beginIndex < 0) {
            throw new IllegalArgumentException("begin index may not be < 0");
        }
        if (beginIndex >= size) {
            throw new IllegalArgumentException("begin index may not be >= the number of path elements");
        }
        if (endIndex > size) {
            throw new IllegalArgumentException("end index may not be > the number of path elements");
        }
        if (endIndex <= beginIndex) {
            throw new IllegalArgumentException("end index may not be <= the begin index");
        }
        String path = String.join((CharSequence)PATH_SEPARATOR, this.pathRepresentation.elements().subList(beginIndex, endIndex));
        if (this.isAbsolute() && beginIndex == 0) {
            path = PATH_SEPARATOR + path;
        }
        if (endIndex == size && !this.pathRepresentation.hasTrailingSeparator()) {
            return this.from(path);
        }
        return this.from(path + PATH_SEPARATOR);
    }

    @Override
    public boolean startsWith(Path other) {
        return this.equals(other) || this.fileSystem.equals(other.getFileSystem()) && this.isAbsolute() == other.isAbsolute() && this.getNameCount() >= other.getNameCount() && this.subpath(0, other.getNameCount()).equals(other);
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.from(other));
    }

    @Override
    public boolean endsWith(Path other) {
        return this.equals(other) || this.fileSystem == other.getFileSystem() && this.getNameCount() >= other.getNameCount() && this.subpath(this.getNameCount() - other.getNameCount(), this.getNameCount()).equals(other);
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.from(other));
    }

    @Override
    public S3Path normalize() {
        if (this.pathRepresentation.isRoot()) {
            return this;
        }
        boolean directory = this.pathRepresentation.isDirectory();
        List<String> elements = this.pathRepresentation.elements();
        LinkedList<String> realElements = new LinkedList<String>();
        for (String element : elements) {
            if (element.equals(".")) continue;
            if (element.equals("..")) {
                if (realElements.isEmpty()) continue;
                realElements.removeLast();
                continue;
            }
            if (directory) {
                realElements.addLast(element + PATH_SEPARATOR);
                continue;
            }
            realElements.addLast(element);
        }
        return S3Path.getPath(this.fileSystem, String.join((CharSequence)PATH_SEPARATOR, realElements), new String[0]);
    }

    @Override
    public S3Path resolve(Path other) {
        if (!(other instanceof S3Path)) {
            throw new ProviderMismatchException("a non s3 path cannot be resolved against and S3Path");
        }
        S3Path s3Other = (S3Path)other;
        if (!this.bucketName().equals(s3Other.bucketName())) {
            throw new IllegalArgumentException("S3Paths cannot be resolved when they are from different buckets");
        }
        if (s3Other.isAbsolute()) {
            return s3Other;
        }
        if (s3Other.isEmpty()) {
            return this;
        }
        String concatenatedPath = !this.pathRepresentation.hasTrailingSeparator() ? this + PATH_SEPARATOR + s3Other : this.toString() + s3Other;
        return this.from(concatenatedPath);
    }

    @Override
    public S3Path resolve(String other) {
        return this.resolve(this.from(other));
    }

    @Override
    public S3Path resolveSibling(Path other) {
        return this.getParent().resolve(other);
    }

    @Override
    public S3Path resolveSibling(String other) {
        return this.getParent().resolve(other);
    }

    @Override
    public S3Path relativize(Path other) {
        int parentDirCount;
        if (!(other instanceof S3Path)) {
            throw new IllegalArgumentException("path is not an S3Path");
        }
        if (this.equals(other)) {
            return this.from("");
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("to obtain a relative path both must be absolute or both must be relative");
        }
        if (!Objects.equals(this.bucketName(), ((S3Path)other).bucketName())) {
            throw new IllegalArgumentException("cannot relativize S3Paths from different buckets");
        }
        S3Path otherPath = (S3Path)other;
        if (this.isEmpty()) {
            return otherPath;
        }
        int nameCount = this.getNameCount();
        int otherNameCount = other.getNameCount();
        int limit = Math.min(nameCount, otherNameCount);
        int differenceCount = this.getDifferenceCount(other, limit);
        if (differenceCount < otherNameCount) {
            return this.getRelativePathFromDifference(otherPath, otherNameCount, differenceCount, parentDirCount);
        }
        char[] relativePath = new char[parentDirCount * 3 - 1];
        int index = 0;
        for (parentDirCount = nameCount - differenceCount; parentDirCount > 0; --parentDirCount) {
            relativePath[index++] = 46;
            relativePath[index++] = 46;
            if (parentDirCount <= 1) continue;
            relativePath[index++] = 47;
        }
        return new S3Path(this.getFileSystem(), new PosixLikePathRepresentation(relativePath));
    }

    private S3Path getRelativePathFromDifference(S3Path otherPath, int otherNameCount, int differenceCount, int parentDirCount) {
        Objects.requireNonNull(otherPath);
        S3Path remainingSubPath = otherPath.subpath(differenceCount, otherNameCount);
        if (parentDirCount == 0) {
            return remainingSubPath;
        }
        int relativePathSize = parentDirCount * 3 + remainingSubPath.pathRepresentation.toString().length();
        if (otherPath.isEmpty()) {
            --relativePathSize;
        }
        char[] relativePath = new char[relativePathSize];
        int index = 0;
        while (parentDirCount > 0) {
            relativePath[index++] = 46;
            relativePath[index++] = 46;
            if (otherPath.isEmpty()) {
                if (parentDirCount > 1) {
                    relativePath[index++] = 47;
                }
            } else {
                relativePath[index++] = 47;
            }
            --parentDirCount;
        }
        System.arraycopy(remainingSubPath.pathRepresentation.chars(), 0, relativePath, index, remainingSubPath.pathRepresentation.chars().length);
        return new S3Path(this.getFileSystem(), new PosixLikePathRepresentation(relativePath));
    }

    private int getDifferenceCount(Path other, int limit) {
        int i;
        for (i = 0; i < limit && this.getName(i).equals(other.getName(i)); ++i) {
        }
        return i;
    }

    private boolean isEmpty() {
        return this.pathRepresentation.toString().isEmpty();
    }

    @Override
    public URI toUri() {
        S3Path path = this.toAbsolutePath().toRealPath(LinkOption.NOFOLLOW_LINKS);
        Iterator<Path> elements = path.iterator();
        StringBuilder uri = new StringBuilder(this.fileSystem.provider().getScheme() + "://");
        uri.append(this.bucketName());
        elements.forEachRemaining(e -> {
            String name = e.getFileName().toString();
            try {
                if (name.endsWith(PATH_SEPARATOR)) {
                    name = name.substring(0, name.length() - 1);
                }
                uri.append(PATH_SEPARATOR).append(URLEncoder.encode(name, "UTF-8"));
            }
            catch (UnsupportedEncodingException x) {
                throw new IllegalArgumentException("path '" + uri + "' can not be converted to URI: " + x.getMessage(), x);
            }
        });
        if (this.isDirectory()) {
            uri.append(PATH_SEPARATOR);
        }
        return URI.create(uri.toString());
    }

    @Override
    public S3Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return new S3Path(this.fileSystem, PosixLikePathRepresentation.of(PATH_SEPARATOR, this.pathRepresentation.toString()));
    }

    @Override
    public S3Path toRealPath(LinkOption ... options) {
        S3Path p = this;
        if (!this.isAbsolute()) {
            p = this.toAbsolutePath();
        }
        return S3Path.getPath(this.fileSystem, PATH_SEPARATOR, p.normalize().toString());
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("S3 Objects cannot be represented in the local (default) file system");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not yet supported. Please raise a feature request describing your use case");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not yet supported. Please raise a feature request describing your use case");
    }

    @Override
    public Iterator<Path> iterator() {
        return new S3PathIterator(this.pathRepresentation.elements().iterator(), this.pathRepresentation.isAbsolute(), this.pathRepresentation.hasTrailingSeparator());
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof S3Path)) {
            throw new ClassCastException("compared paths must be from the same provider");
        }
        S3Path o = (S3Path)other;
        if (o.fileSystem != this.fileSystem) {
            throw new ClassCastException("compared S3 paths must be from the same bucket");
        }
        return this.toRealPath(LinkOption.NOFOLLOW_LINKS).toString().compareTo(o.toRealPath(LinkOption.NOFOLLOW_LINKS).toString());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof S3Path && Objects.equals(((S3Path)other).bucketName(), this.bucketName()) && Objects.equals(((S3Path)other).toRealPath((LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}).pathRepresentation, this.toRealPath((LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}).pathRepresentation);
    }

    @Override
    public int hashCode() {
        return this.bucketName().hashCode() + this.toRealPath((LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}).pathRepresentation.hashCode();
    }

    @Override
    public String toString() {
        return this.pathRepresentation.toString();
    }

    public String getKey() {
        if (this.isEmpty()) {
            return "";
        }
        String s = this.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
        if (s.startsWith(PATH_SEPARATOR + this.bucketName())) {
            s = s.replaceFirst(PATH_SEPARATOR + this.bucketName(), "");
        }
        while (s.startsWith(PATH_SEPARATOR)) {
            s = s.substring(1);
        }
        return s;
    }

    private final class S3PathIterator
    implements Iterator<Path> {
        private final Iterator<String> delegate;
        boolean first;
        final boolean isAbsolute;
        final boolean hasTrailingSeparator;

        public S3PathIterator(Iterator<String> delegate, boolean isAbsolute, boolean hasTrailingSeparator) {
            this.delegate = delegate;
            this.isAbsolute = isAbsolute;
            this.hasTrailingSeparator = hasTrailingSeparator;
            this.first = true;
        }

        @Override
        public Path next() {
            String pathString = this.delegate.next();
            if (S3Path.this.isAbsolute() && this.first) {
                this.first = false;
                pathString = S3Path.PATH_SEPARATOR + pathString;
                if (!this.hasNext() && this.hasTrailingSeparator) {
                    pathString = pathString + S3Path.PATH_SEPARATOR;
                }
            }
            if (this.hasNext() || this.hasTrailingSeparator) {
                pathString = pathString + S3Path.PATH_SEPARATOR;
            }
            return S3Path.this.from(pathString);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

