/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3ReadAheadByteChannel;
import software.amazon.nio.spi.s3.S3WritableByteChannel;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;
import software.amazon.nio.spi.s3.util.TimeOutUtils;

public class S3SeekableByteChannel
implements SeekableByteChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3SeekableByteChannel.class);
    private long position;
    private final S3AsyncClient s3Client;
    private final S3Path path;
    private final ReadableByteChannel readDelegate;
    private final S3WritableByteChannel writeDelegate;
    private boolean closed;
    private long size = -1L;

    protected S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client) throws IOException {
        this(s3Path, s3Client, Collections.singleton(StandardOpenOption.READ));
    }

    @Deprecated
    protected S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client, long startAt) throws IOException {
        this(s3Path, s3Client, startAt, Collections.singleton(StandardOpenOption.READ), null, null);
    }

    @Deprecated
    protected S3SeekableByteChannel(S3Path s3Path, long startAt) throws IOException {
        this(s3Path, s3Path.getFileSystem().client(), startAt);
    }

    protected S3SeekableByteChannel(S3Path s3Path) throws IOException {
        this(s3Path, s3Path.getFileSystem().client(), Collections.singleton(StandardOpenOption.READ));
    }

    protected S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client, Set<? extends OpenOption> options) throws IOException {
        this(s3Path, s3Client, 0L, options, null, null);
    }

    protected S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client, Set<? extends OpenOption> options, long timeout, TimeUnit timeUnit) throws IOException {
        this(s3Path, s3Client, 0L, options, timeout, timeUnit);
    }

    private S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client, long startAt, Set<? extends OpenOption> options, Long timeout, TimeUnit timeUnit) throws IOException {
        this.position = startAt;
        this.path = s3Path;
        this.closed = false;
        this.s3Client = s3Client;
        s3Path.getFileSystem().registerOpenChannel(this);
        if (options.contains(StandardOpenOption.WRITE) && options.contains(StandardOpenOption.READ)) {
            throw new IOException("This channel does not support read and write access simultaneously");
        }
        if (options.contains(StandardOpenOption.SYNC) || options.contains(StandardOpenOption.DSYNC)) {
            throw new IOException("The SYNC/DSYNC options is not supported");
        }
        S3NioSpiConfiguration config = new S3NioSpiConfiguration();
        if (options.contains(StandardOpenOption.WRITE)) {
            LOGGER.debug("using S3WritableByteChannel as write delegate for path '{}'", (Object)s3Path.toUri());
            this.readDelegate = null;
            this.writeDelegate = new S3WritableByteChannel(s3Path, s3Client, options, timeout, timeUnit);
            this.position = 0L;
        } else if (options.contains(StandardOpenOption.READ) || options.size() == 0) {
            LOGGER.debug("using S3ReadAheadByteChannel as read delegate for path '{}'", (Object)s3Path.toUri());
            this.readDelegate = new S3ReadAheadByteChannel(s3Path, config.getMaxFragmentSize(), config.getMaxFragmentNumber(), s3Client, this, timeout, timeUnit);
            this.writeDelegate = null;
        } else {
            throw new IOException("Invalid channel mode");
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.validateOpen();
        if (this.readDelegate == null) {
            throw new NonReadableChannelException();
        }
        return this.readDelegate.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.validateOpen();
        if (this.writeDelegate == null) {
            throw new NonWritableChannelException();
        }
        int length = src.remaining();
        this.position += (long)length;
        return this.writeDelegate.write(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        this.validateOpen();
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition cannot be < 0");
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.readDelegate == null) {
            throw new NonReadableChannelException();
        }
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            this.position = newPosition;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        this.validateOpen();
        if (this.size < 0L) {
            long timeOut = 1L;
            TimeUnit unit = TimeUnit.MINUTES;
            LOGGER.debug("requesting size of '{}'", (Object)this.path.toUri());
            S3SeekableByteChannel s3SeekableByteChannel = this;
            synchronized (s3SeekableByteChannel) {
                HeadObjectResponse headObjectResponse;
                try {
                    headObjectResponse = (HeadObjectResponse)this.s3Client.headObject(builder -> builder.bucket(this.path.bucketName()).key(this.path.getKey())).get(timeOut, unit);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
                catch (TimeoutException e) {
                    throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(LOGGER, "size", timeOut, unit);
                }
                LOGGER.debug("size of '{}' is '{}'", (Object)this.path.toUri(), (Object)headObjectResponse.contentLength());
                this.size = headObjectResponse.contentLength();
            }
        }
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("Currently not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            if (this.readDelegate != null) {
                this.readDelegate.close();
            }
            if (this.writeDelegate != null) {
                this.writeDelegate.close();
            }
            this.closed = true;
            this.path.getFileSystem().deregisterClosedChannel(this);
        }
    }

    private void validateOpen() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    protected ReadableByteChannel getReadDelegate() {
        return this.readDelegate;
    }

    protected WritableByteChannel getWriteDelegate() {
        return this.writeDelegate;
    }
}

