/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.nio.spi.s3.S3FileSystemProvider;
import software.amazon.nio.spi.s3.S3Path;

public class S3WritableByteChannel
implements WritableByteChannel {
    private final S3AsyncClient client;
    private final S3Path path;
    private final Path tempFile;
    private final SeekableByteChannel channel;
    private final Long timeout;
    private final TimeUnit timeUnit;
    private boolean open;

    public S3WritableByteChannel(S3Path path, S3AsyncClient client, Set<? extends OpenOption> options) throws IOException {
        this(path, client, options, null, null);
    }

    public S3WritableByteChannel(S3Path path, S3AsyncClient client, Set<? extends OpenOption> options, Long timeout, TimeUnit timeUnit) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(client);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        try {
            S3FileSystemProvider fileSystemProvider = (S3FileSystemProvider)path.getFileSystem().provider();
            boolean exists = fileSystemProvider.exists(client, path);
            if (exists && options.contains(StandardOpenOption.CREATE_NEW)) {
                throw new FileAlreadyExistsException("File at path:" + path + " already exists");
            }
            if (!(exists || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.CREATE))) {
                throw new NoSuchFileException("File at path:" + path + " does not exist yet");
            }
            this.tempFile = Files.createTempFile("aws-s3-nio-", ".tmp", new FileAttribute[0]);
            if (exists) {
                try (S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(client).build();){
                    CompletableFuture downloadCompletableFuture = s3TransferManager.downloadFile((DownloadFileRequest)DownloadFileRequest.builder().getObjectRequest((GetObjectRequest)GetObjectRequest.builder().bucket(path.bucketName()).key(path.getKey()).build()).destination(this.tempFile).build()).completionFuture();
                    if (timeout != null && timeUnit != null) {
                        downloadCompletableFuture.get(timeout, timeUnit);
                    } else {
                        downloadCompletableFuture.join();
                    }
                }
            }
            options.remove(StandardOpenOption.CREATE_NEW);
            this.channel = Files.newByteChannel(this.tempFile, options, new FileAttribute[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Could not open the path:" + path, e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException("Could not open the path:" + path, e);
        }
        this.client = client;
        this.path = path;
        this.open = true;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        try (S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(this.client).build();){
            CompletableFuture uploadCompletableFuture = s3TransferManager.uploadFile((UploadFileRequest)UploadFileRequest.builder().putObjectRequest((PutObjectRequest)PutObjectRequest.builder().bucket(this.path.bucketName()).key(this.path.getKey()).build()).source(this.tempFile).build()).completionFuture();
            if (this.timeout != null && this.timeUnit != null) {
                uploadCompletableFuture.get(this.timeout, this.timeUnit);
            } else {
                uploadCompletableFuture.join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Could not write to path:" + this.path, e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException("Could not write to path:" + this.path, e);
        }
        this.open = false;
    }
}

