/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.services.s3.internal.BucketUtils;
import software.amazon.awssdk.utils.Pair;
import software.amazon.nio.spi.s3.util.StringUtils;

public class S3NioSpiConfiguration
extends HashMap<String, Object> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String AWS_REGION_PROPERTY = "aws.region";
    public static final String AWS_ACCESS_KEY_PROPERTY = "aws.accessKey";
    public static final String AWS_SECRET_ACCESS_KEY_PROPERTY = "aws.secretAccessKey";
    public static final String S3_SPI_READ_MAX_FRAGMENT_SIZE_PROPERTY = "s3.spi.read.max-fragment-size";
    public static final int S3_SPI_READ_MAX_FRAGMENT_SIZE_DEFAULT = 0x500000;
    public static final String S3_SPI_READ_MAX_FRAGMENT_NUMBER_PROPERTY = "s3.spi.read.max-fragment-number";
    public static final int S3_SPI_READ_MAX_FRAGMENT_NUMBER_DEFAULT = 50;
    public static final String S3_SPI_ENDPOINT_PROPERTY = "s3.spi.endpoint";
    public static final String S3_SPI_ENDPOINT_DEFAULT = "";
    public static final String S3_SPI_ENDPOINT_PROTOCOL_PROPERTY = "s3.spi.endpoint-protocol";
    public static final String S3_SPI_ENDPOINT_PROTOCOL_DEFAULT = "https";
    public static final String S3_SPI_FORCE_PATH_STYLE_PROPERTY = "s3.spi.force-path-style";
    public static final String S3_SPI_CREDENTIALS_PROPERTY = "s3.spi.credentials";
    private final Pattern ENDPOINT_REGEXP = Pattern.compile("(\\w[\\w\\-\\.]*)?(:(\\d+))?");
    private String bucketName;

    public S3NioSpiConfiguration() {
        this(new HashMap());
    }

    public S3NioSpiConfiguration(Map<String, ?> overrides) {
        Objects.requireNonNull(overrides);
        this.put(S3_SPI_READ_MAX_FRAGMENT_NUMBER_PROPERTY, String.valueOf(50));
        this.put(S3_SPI_READ_MAX_FRAGMENT_SIZE_PROPERTY, String.valueOf(0x500000));
        this.put(S3_SPI_ENDPOINT_PROTOCOL_PROPERTY, S3_SPI_ENDPOINT_PROTOCOL_DEFAULT);
        this.keySet().stream().map(key -> Pair.of((Object)key, Optional.ofNullable(System.getenv().get(this.convertPropertyNameToEnvVar((String)key))))).forEach((? super T pair) -> ((Optional)pair.right()).ifPresent(val -> this.put((String)pair.left(), val)));
        this.keySet().forEach((? super T key) -> Optional.ofNullable(System.getProperty(key)).ifPresent(val -> this.put(key, val)));
        overrides.keySet().forEach((? super T key) -> this.put(key, overrides.get(key)));
    }

    protected S3NioSpiConfiguration(Properties overrides) {
        Objects.requireNonNull(overrides);
        overrides.stringPropertyNames().forEach((? super T key) -> this.put(key, overrides.getProperty((String)key)));
    }

    public S3NioSpiConfiguration withMaxFragmentNumber(int maxFragmentNumber) {
        if (maxFragmentNumber < 1) {
            throw new IllegalArgumentException("maxFragmentNumber must be positive");
        }
        this.put(S3_SPI_READ_MAX_FRAGMENT_NUMBER_PROPERTY, String.valueOf(maxFragmentNumber));
        return this;
    }

    public S3NioSpiConfiguration withMaxFragmentSize(int maxFragmentSize) {
        if (maxFragmentSize < 1) {
            throw new IllegalArgumentException("maxFragmentSize must be positive");
        }
        this.put(S3_SPI_READ_MAX_FRAGMENT_SIZE_PROPERTY, String.valueOf(maxFragmentSize));
        return this;
    }

    public S3NioSpiConfiguration withEndpoint(String endpoint) {
        if (endpoint == null) {
            endpoint = S3_SPI_ENDPOINT_DEFAULT;
        }
        if ((endpoint = endpoint.trim()).length() > 0 && !this.ENDPOINT_REGEXP.matcher(endpoint).matches()) {
            throw new IllegalArgumentException(String.format("endpoint '%s' does not match format host:port where port is a number", endpoint));
        }
        this.put(S3_SPI_ENDPOINT_PROPERTY, endpoint);
        return this;
    }

    public S3NioSpiConfiguration withEndpointProtocol(String protocol) {
        if (protocol != null) {
            protocol = protocol.trim();
        }
        if (!"http".equals(protocol) && !S3_SPI_ENDPOINT_PROTOCOL_DEFAULT.equals(protocol)) {
            throw new IllegalArgumentException("endpoint prococol must be one of ('http', 'https')");
        }
        this.put(S3_SPI_ENDPOINT_PROTOCOL_PROPERTY, protocol);
        return this;
    }

    public S3NioSpiConfiguration withRegion(String region) {
        if (region == null || StringUtils.isBlank(region)) {
            this.remove(AWS_REGION_PROPERTY);
        } else {
            this.put(AWS_REGION_PROPERTY, region.trim());
        }
        return this;
    }

    public S3NioSpiConfiguration withBucketName(String bucketName) {
        if (bucketName != null) {
            BucketUtils.isValidDnsBucketName((String)bucketName, (boolean)true);
        }
        this.bucketName = bucketName;
        return this;
    }

    public S3NioSpiConfiguration withCredentials(String accessKey, String secretAccessKey) {
        AwsBasicCredentials credentials = null;
        if (accessKey == null) {
            this.remove(AWS_ACCESS_KEY_PROPERTY);
            this.remove(AWS_SECRET_ACCESS_KEY_PROPERTY);
        } else {
            if (secretAccessKey == null) {
                throw new IllegalArgumentException("secretAccessKey can not be null");
            }
            this.put(AWS_ACCESS_KEY_PROPERTY, accessKey);
            this.put(AWS_SECRET_ACCESS_KEY_PROPERTY, secretAccessKey);
            credentials = AwsBasicCredentials.create((String)accessKey, (String)secretAccessKey);
        }
        this.withCredentials((AwsCredentials)credentials);
        return this;
    }

    public S3NioSpiConfiguration withCredentials(AwsCredentials credentials) {
        if (credentials == null) {
            this.remove(S3_SPI_CREDENTIALS_PROPERTY);
        } else {
            this.put(S3_SPI_CREDENTIALS_PROPERTY, credentials);
        }
        return this;
    }

    public S3NioSpiConfiguration withForcePathStyle(Boolean forcePathStyle) {
        if (forcePathStyle == null) {
            this.remove(S3_SPI_FORCE_PATH_STYLE_PROPERTY);
        } else {
            this.put(S3_SPI_FORCE_PATH_STYLE_PROPERTY, forcePathStyle);
        }
        return this;
    }

    public int getMaxFragmentSize() {
        return this.parseIntProperty(S3_SPI_READ_MAX_FRAGMENT_SIZE_PROPERTY, 0x500000);
    }

    public int getMaxFragmentNumber() {
        return this.parseIntProperty(S3_SPI_READ_MAX_FRAGMENT_NUMBER_PROPERTY, 50);
    }

    public String getEndpoint() {
        return this.getOrDefault(S3_SPI_ENDPOINT_PROPERTY, S3_SPI_ENDPOINT_DEFAULT);
    }

    public String getEndpointProtocol() {
        String protocol = this.getOrDefault(S3_SPI_ENDPOINT_PROTOCOL_PROPERTY, S3_SPI_ENDPOINT_PROTOCOL_DEFAULT);
        if ("http".equalsIgnoreCase(protocol) || S3_SPI_ENDPOINT_PROTOCOL_DEFAULT.equalsIgnoreCase(protocol)) {
            return protocol;
        }
        this.logger.warn("the value of '{}' for '{}' is not 'http'|'https', using default value of '{}'", new Object[]{protocol, S3_SPI_ENDPOINT_PROTOCOL_PROPERTY, S3_SPI_ENDPOINT_PROTOCOL_DEFAULT});
        return S3_SPI_ENDPOINT_PROTOCOL_DEFAULT;
    }

    public AwsCredentials getCredentials() {
        if (this.containsKey(S3_SPI_CREDENTIALS_PROPERTY)) {
            return (AwsCredentials)this.get(S3_SPI_CREDENTIALS_PROPERTY);
        }
        if (this.containsKey(AWS_ACCESS_KEY_PROPERTY)) {
            return AwsBasicCredentials.create((String)((String)this.get(AWS_ACCESS_KEY_PROPERTY)), (String)((String)this.get(AWS_SECRET_ACCESS_KEY_PROPERTY)));
        }
        return null;
    }

    public String getRegion() {
        return (String)this.get(AWS_REGION_PROPERTY);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public boolean getForcePathStyle() {
        return this.getOrDefault(S3_SPI_FORCE_PATH_STYLE_PROPERTY, false);
    }

    protected String convertPropertyNameToEnvVar(String propertyName) {
        if (propertyName == null || propertyName.trim().isEmpty()) {
            return S3_SPI_ENDPOINT_DEFAULT;
        }
        return propertyName.trim().replace('.', '_').replace('-', '_').toUpperCase(Locale.ROOT);
    }

    private int parseIntProperty(String propName, int defaultVal) {
        String propertyVal = (String)this.get(propName);
        try {
            return Integer.parseInt(propertyVal);
        }
        catch (NumberFormatException e) {
            this.logger.warn("the value of '{}' for '{}' is not an integer, using default value of '{}'", new Object[]{propertyVal, propName, defaultVal});
            return defaultVal;
        }
    }
}

