/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3.util;

import java.net.URI;
import software.amazon.awssdk.services.s3.internal.BucketUtils;

public class S3FileSystemInfo {
    protected String key;
    protected String endpoint;
    protected String bucket;
    protected String accessKey;
    protected String accessSecret;

    protected S3FileSystemInfo() {
    }

    public S3FileSystemInfo(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri can not be null");
        }
        this.key = this.bucket = uri.getAuthority();
        this.accessSecret = null;
        this.accessKey = null;
        this.endpoint = null;
        BucketUtils.isValidDnsBucketName((String)this.bucket, (boolean)true);
    }

    public String key() {
        return this.key;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String bucket() {
        return this.bucket;
    }

    public String accessKey() {
        return this.accessKey;
    }

    public String accessSecret() {
        return this.accessSecret;
    }
}

