/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3.util;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class TimeOutUtils {
    public static final long TIMEOUT_TIME_LENGTH_1 = 1L;
    public static long TIMEOUT_TIME_LENGTH_3 = 3L;
    public static final long TIMEOUT_TIME_LENGTH_5 = 5L;

    public static String createTimeOutMessage(String operationName, long length, TimeUnit unit) {
        return String.format("the %s operation timed out after %d %s, check your network connectivity and status of S3 service", operationName, length, unit.toString().toLowerCase(Locale.ROOT));
    }

    public static String createAndLogTimeOutMessage(Logger logger, String operationName, long length, TimeUnit unit) {
        Objects.requireNonNull(logger);
        String msg = TimeOutUtils.createTimeOutMessage(operationName, length, unit);
        logger.error(msg);
        return msg;
    }

    public static RuntimeException logAndGenerateExceptionOnTimeOut(Logger logger, String operationName, long length, TimeUnit unit) {
        Objects.requireNonNull(logger);
        String msg = TimeOutUtils.createAndLogTimeOutMessage(logger, operationName, length, unit);
        return new RuntimeException(msg);
    }
}

