/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3x;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import software.amazon.nio.spi.s3.S3FileSystem;
import software.amazon.nio.spi.s3.S3FileSystemProvider;
import software.amazon.nio.spi.s3.util.S3FileSystemInfo;
import software.amazon.nio.spi.s3x.util.S3XFileSystemInfo;

public class S3XFileSystemProvider
extends S3FileSystemProvider {
    public static final String SCHEME = "s3x";

    @Override
    public S3FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        HashMap<String, Object> newEnv = new HashMap<String, Object>();
        newEnv.putAll(env);
        newEnv.putIfAbsent("s3.spi.force-path-style", true);
        return super.newFileSystem(uri, newEnv);
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    protected S3FileSystemInfo fileSystemInfo(URI uri) {
        return new S3XFileSystemInfo(uri);
    }
}

