/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class PosixLikePathRepresentation {
    static final PosixLikePathRepresentation ROOT = new PosixLikePathRepresentation("/");
    static final PosixLikePathRepresentation EMPTY_PATH = new PosixLikePathRepresentation("");
    private static final char PATH_SEPARATOR_CHAR = "/".charAt(0);
    private String path;

    PosixLikePathRepresentation(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        this.path = path;
    }

    PosixLikePathRepresentation(char[] path) {
        new PosixLikePathRepresentation(new String(path));
    }

    static PosixLikePathRepresentation of(String first, String ... more) {
        if ((first == null || first.trim().isEmpty()) && more != null && more.length != 0) {
            throw new IllegalArgumentException("The first element of the path may not be null or empty when more exists");
        }
        if (first == null || first.trim().isEmpty()) {
            return EMPTY_PATH;
        }
        LinkedList<String> allParts = new LinkedList<String>();
        allParts.add(first);
        allParts.addAll(PosixLikePathRepresentation.collectMore(more));
        if (allParts.peekLast() == null) {
            throw new RuntimeException("the last element of the path representation is unexpectedly null");
        }
        boolean endsWithSeparator = PosixLikePathRepresentation.hasTrailingSeparatorString((String)allParts.peekLast());
        boolean startsWithSeparator = PosixLikePathRepresentation.isAbsoluteString((String)allParts.peekFirst());
        String path = PosixLikePathRepresentation.partsToPathString(allParts, endsWithSeparator, startsWithSeparator);
        return new PosixLikePathRepresentation(path);
    }

    private static String partsToPathString(LinkedList<String> allParts, boolean endsWithSeparator, boolean startsWithSeparator) {
        Object path = allParts.stream().flatMap(part -> Arrays.stream(part.split("/+"))).filter(p -> !p.isEmpty()).collect(Collectors.joining("/"));
        if (endsWithSeparator && !PosixLikePathRepresentation.hasTrailingSeparatorString((String)path)) {
            path = (String)path + "/";
        }
        if (startsWithSeparator && !PosixLikePathRepresentation.isAbsoluteString((String)path)) {
            path = "/" + (String)path;
        }
        return path;
    }

    private static List<String> collectMore(String[] more) {
        if (more != null && more.length != 0) {
            return Arrays.stream(more).filter(Objects::nonNull).filter(p -> !p.isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    boolean isRoot() {
        return PosixLikePathRepresentation.isRootString(this.path);
    }

    private static boolean isRootString(String path) {
        return path.equals("/");
    }

    boolean isAbsolute() {
        return PosixLikePathRepresentation.isAbsoluteString(this.path);
    }

    private static boolean isAbsoluteString(String path) {
        return path != null && !path.isEmpty() && path.charAt(0) == PATH_SEPARATOR_CHAR;
    }

    boolean isDirectory() {
        return PosixLikePathRepresentation.isDirectoryString(this.path);
    }

    private static boolean isDirectoryString(String path) {
        return path.isEmpty() || PosixLikePathRepresentation.hasTrailingSeparatorString(path) || path.equals(".") || path.equals("..") || path.endsWith(PATH_SEPARATOR_CHAR + ".") || path.endsWith(PATH_SEPARATOR_CHAR + "..");
    }

    boolean hasTrailingSeparator() {
        return PosixLikePathRepresentation.hasTrailingSeparatorString(this.path);
    }

    private static boolean hasTrailingSeparatorString(String path) {
        if (path.isEmpty()) {
            return false;
        }
        return path.charAt(path.length() - 1) == PATH_SEPARATOR_CHAR;
    }

    char[] chars() {
        return this.path.toCharArray();
    }

    public String toString() {
        return this.path;
    }

    List<String> elements() {
        if (this.isRoot()) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.path.split("/")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PosixLikePathRepresentation that = (PosixLikePathRepresentation)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }
}

