/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.nio.spi.s3.S3BasicFileAttributes;
import software.amazon.nio.spi.s3.S3Path;

class S3BasicFileAttributeView
implements BasicFileAttributeView {
    private final Logger logger = LoggerFactory.getLogger((String)"S3BasicFileAttributeView");
    private final S3Path path;

    S3BasicFileAttributeView(S3Path path) {
        this.path = path;
    }

    @Override
    public String name() {
        return "s3";
    }

    @Override
    public BasicFileAttributes readAttributes() throws IOException {
        return S3BasicFileAttributes.get(this.path, Duration.ofMinutes(1L));
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
        this.logger.warn("S3 doesn't support setting of file times other than by writing the file. The time set during those operations will be determined by S3. This method call will be ignored");
    }
}

