/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.util.TimeOutUtils;

class S3BasicFileAttributes
implements BasicFileAttributes {
    private static final FileTime EPOCH_FILE_TIME = FileTime.from(Instant.EPOCH);
    private static final S3BasicFileAttributes DIRECTORY_ATTRIBUTES = new S3BasicFileAttributes(EPOCH_FILE_TIME, 0L, null, true, false);
    private static final Set<String> METHOD_NAMES_TO_FILTER_OUT = Set.of("wait", "toString", "hashCode", "getClass", "notify", "notifyAll");
    private static final Logger logger = LoggerFactory.getLogger((String)S3BasicFileAttributes.class.getName());
    private final FileTime lastModifiedTime;
    private final Long size;
    private final Object eTag;
    private final boolean isDirectory;
    private final boolean isRegularFile;

    private S3BasicFileAttributes(FileTime lastModifiedTime, Long size, Object eTag, boolean isDirectory, boolean isRegularFile) {
        this.lastModifiedTime = lastModifiedTime;
        this.size = size;
        this.eTag = eTag;
        this.isDirectory = isDirectory;
        this.isRegularFile = isRegularFile;
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastModifiedTime();
    }

    @Override
    public FileTime creationTime() {
        return this.lastModifiedTime();
    }

    @Override
    public boolean isRegularFile() {
        return this.isRegularFile;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object fileKey() {
        return this.eTag;
    }

    protected Map<String, Object> asMap(Predicate<String> attributeFilter) {
        return Arrays.stream(this.getClass().getMethods()).filter(method -> method.getParameterCount() == 0).filter(method -> !METHOD_NAMES_TO_FILTER_OUT.contains(method.getName())).filter(method -> attributeFilter.test(method.getName())).collect(Collectors.toMap(Method::getName, method -> {
            logger.debug("method name: '{}'", (Object)method.getName());
            try {
                return method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String errorMsg = "an exception has occurred during a reflection operation on the methods of file attributes,check if your Java SecurityManager is configured to allow reflection.";
                logger.error("{}, caused by {}", (Object)errorMsg, (Object)e.getCause().getMessage());
                throw new RuntimeException(errorMsg, e);
            }
        }));
    }

    static S3BasicFileAttributes get(S3Path path, Duration readTimeout) throws IOException {
        if (path.isDirectory()) {
            return DIRECTORY_ATTRIBUTES;
        }
        HeadObjectResponse headResponse = S3BasicFileAttributes.getObjectMetadata(path, readTimeout);
        return new S3BasicFileAttributes(FileTime.from(headResponse.lastModified()), headResponse.contentLength(), headResponse.eTag(), false, true);
    }

    private static HeadObjectResponse getObjectMetadata(S3Path path, Duration timeout) throws IOException {
        S3AsyncClient client = path.getFileSystem().client();
        String bucketName = path.bucketName();
        try {
            return (HeadObjectResponse)client.headObject(req -> req.bucket(bucketName).key(path.getKey())).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            String errMsg = String.format("an '%s' error occurred while obtaining the metadata (for operation getFileAttributes) of '%s'that was not handled successfully by the S3Client's configured RetryConditions", e.getCause().toString(), path.toUri());
            logger.error(errMsg);
            throw new IOException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (TimeoutException e) {
            String msg = TimeOutUtils.createAndLogTimeOutMessage(logger, "getFileAttributes", timeout.toMillis(), TimeUnit.MILLISECONDS);
            throw new IOException(msg, e);
        }
    }
}

