/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.time.Duration;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.nio.spi.s3.CacheableS3Client;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;

public class S3ClientProvider {
    @Deprecated
    protected S3AsyncClient universalClient;
    protected final S3NioSpiConfiguration configuration;
    protected S3CrtAsyncClientBuilder asyncClientBuilder = S3AsyncClient.crtBuilder().crossRegionAccessEnabled(Boolean.valueOf(true));
    private final Cache<String, CacheableS3Client> bucketClientCache = Caffeine.newBuilder().maximumSize(4L).expireAfterWrite(Duration.ofHours(1L)).build();

    public S3ClientProvider(S3NioSpiConfiguration c) {
        this.configuration = c == null ? new S3NioSpiConfiguration() : c;
    }

    public void asyncClientBuilder(S3CrtAsyncClientBuilder builder) {
        this.asyncClientBuilder = builder;
    }

    protected S3AsyncClient generateClient(String bucket) {
        CacheableS3Client client = (CacheableS3Client)((Object)this.bucketClientCache.getIfPresent((Object)bucket));
        if (client != null && !client.isClosed()) {
            return client;
        }
        if (client != null && client.isClosed()) {
            this.bucketClientCache.invalidate((Object)bucket);
        }
        return (S3AsyncClient)this.bucketClientCache.get((Object)bucket, b -> new CacheableS3Client(this.configureCrtClient().build()));
    }

    S3CrtAsyncClientBuilder configureCrtClient() {
        AwsCredentials credentials;
        URI endpointUri = this.configuration.endpointUri();
        if (endpointUri != null) {
            this.asyncClientBuilder.endpointOverride(endpointUri);
        }
        if ((credentials = this.configuration.getCredentials()) != null) {
            this.asyncClientBuilder.credentialsProvider(() -> credentials);
        }
        return this.asyncClientBuilder.forcePathStyle(Boolean.valueOf(this.configuration.getForcePathStyle()));
    }
}

