/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher;
import software.amazon.nio.spi.s3.S3FileSystem;
import software.amazon.nio.spi.s3.S3Path;

class S3DirectoryStream
implements DirectoryStream<Path> {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Iterator<Path> iterator;

    S3DirectoryStream(S3FileSystem fs, String bucketName, String finalDirName, DirectoryStream.Filter<? super Path> filter) {
        ListObjectsV2Publisher listObjectsV2Publisher = fs.client().listObjectsV2Paginator(req -> req.bucket(bucketName).prefix(finalDirName).delimiter("/"));
        this.iterator = this.pathIteratorForPublisher(filter, fs, finalDirName, listObjectsV2Publisher);
        this.iterator.hasNext();
    }

    @Override
    public @NonNull Iterator<Path> iterator() {
        return this.iterator;
    }

    @Override
    public void close() {
    }

    private Iterator<Path> pathIteratorForPublisher(DirectoryStream.Filter<? super Path> filter, FileSystem fs, String finalDirName, ListObjectsV2Publisher listObjectsV2Publisher) throws SdkException {
        SdkPublisher prefixPublisher = listObjectsV2Publisher.commonPrefixes().map(CommonPrefix::prefix);
        SdkPublisher keysPublisher = listObjectsV2Publisher.contents().map(S3Object::key);
        return Flowable.concat((Publisher)prefixPublisher, (Publisher)keysPublisher).map(x$0 -> fs.getPath((String)x$0, new String[0])).filter(path -> !S3DirectoryStream.isEqualToParent(finalDirName, path)).filter(path -> this.tryAccept(filter, (Path)path)).blockingIterable().iterator();
    }

    private static boolean isEqualToParent(String finalDirName, Path p) {
        return ((S3Path)p).getKey().equals(finalDirName);
    }

    private boolean tryAccept(DirectoryStream.Filter<? super Path> filter, Path path) {
        try {
            return filter.accept(path);
        }
        catch (IOException e) {
            this.logger.warn("An IOException was thrown while filtering the path: {}. Set log level to debug to show stack trace", (Object)path);
            this.logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

