/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import software.amazon.nio.spi.s3.NotYetImplementedException;
import software.amazon.nio.spi.s3.S3SeekableByteChannel;
import software.amazon.nio.spi.s3.S3WritableByteChannel;

public class S3FileChannel
extends FileChannel {
    private final S3SeekableByteChannel byteChannel;

    S3FileChannel(S3SeekableByteChannel byteChannel) {
        this.byteChannel = byteChannel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.byteChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        ByteBuffer dst;
        int bytesRead;
        int totalBytesRead = 0;
        for (int i = offset; i < offset + length && (bytesRead = this.read(dst = dsts[i])) != -1; ++i) {
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.byteChannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int bytesWritten = 0;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer src = srcs[i];
            bytesWritten += this.write(src);
        }
        return bytesWritten;
    }

    @Override
    public long position() throws IOException {
        return this.byteChannel.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.byteChannel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.byteChannel.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.byteChannel.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        if (this.byteChannel.getWriteDelegate() != null) {
            ((S3WritableByteChannel)this.byteChannel.getWriteDelegate()).force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count must be non-negative");
        }
        if (count == 0L || position > this.byteChannel.size()) {
            return 0L;
        }
        if (this.byteChannel.getReadDelegate() == null) {
            throw new NonReadableChannelException();
        }
        if (!this.byteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        S3SeekableByteChannel s3SeekableByteChannel = this.byteChannel;
        synchronized (s3SeekableByteChannel) {
            int bytesToTransfer;
            ByteBuffer buffer;
            long bytesTransferred;
            int bytesRead;
            long originalPosition = this.byteChannel.position();
            this.byteChannel.position(position);
            for (bytesTransferred = 0L; bytesTransferred < count && (bytesRead = this.byteChannel.read(buffer = ByteBuffer.allocate(bytesToTransfer = (int)Math.min(count - bytesTransferred, Integer.MAX_VALUE)))) != -1; bytesTransferred += (long)bytesRead) {
                buffer.flip();
                target.write(buffer);
            }
            this.byteChannel.position(originalPosition);
            return bytesTransferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("file position must be non-negative");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("byte count must be non-negative");
        }
        if (count == 0L || position > this.byteChannel.size()) {
            return 0L;
        }
        if (this.byteChannel.getWriteDelegate() == null) {
            throw new NonWritableChannelException();
        }
        if (!this.byteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        S3SeekableByteChannel s3SeekableByteChannel = this.byteChannel;
        synchronized (s3SeekableByteChannel) {
            int bytesToTransfer;
            ByteBuffer buffer;
            long bytesTransferred;
            int bytesRead;
            long originalPosition = this.byteChannel.position();
            this.byteChannel.position(position);
            for (bytesTransferred = 0L; bytesTransferred < count && (bytesRead = src.read(buffer = ByteBuffer.allocate(bytesToTransfer = (int)Math.min(count - bytesTransferred, Integer.MAX_VALUE)))) != -1; bytesTransferred += (long)bytesRead) {
                buffer.flip();
                this.byteChannel.write(buffer);
            }
            this.byteChannel.position(originalPosition);
            return bytesTransferred;
        }
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("file position must be non-negative");
        }
        this.byteChannel.position(position);
        return this.byteChannel.read(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        S3SeekableByteChannel s3SeekableByteChannel = this.byteChannel;
        synchronized (s3SeekableByteChannel) {
            long originalPosition = this.byteChannel.position();
            this.byteChannel.position(position);
            int bytesWritten = this.byteChannel.write(src);
            this.byteChannel.position(originalPosition);
            return bytesWritten;
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new IOException(new NotYetImplementedException("This library current doesn't support MappedByteBuffers"));
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new IOException(new UnsupportedOperationException("S3 does not support file locks"));
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new IOException(new UnsupportedOperationException("S3 does not support file locks"));
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.byteChannel.close();
    }
}

