/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.nio.spi.s3.S3ClientProvider;
import software.amazon.nio.spi.s3.S3FileSystemProvider;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3SeekableByteChannel;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;

public class S3FileSystem
extends FileSystem {
    static final Logger logger = LoggerFactory.getLogger(S3FileSystem.class);
    static final String BASIC_FILE_ATTRIBUTE_VIEW = "basic";
    private static final Set<String> SUPPORTED_FILE_ATTRIBUTE_VIEWS = Collections.singleton("basic");
    S3ClientProvider clientProvider;
    private final String bucketName;
    private final S3FileSystemProvider provider;
    private boolean open = true;
    private final Set<S3SeekableByteChannel> openChannels = new HashSet<S3SeekableByteChannel>();
    private final S3NioSpiConfiguration configuration;

    S3FileSystem(S3FileSystemProvider provider, S3NioSpiConfiguration config) {
        this.configuration = config == null ? new S3NioSpiConfiguration() : config;
        this.bucketName = this.configuration.getBucketName();
        provider.setConfiguration(config);
        logger.debug("creating FileSystem for '{}://{}'", (Object)provider.getScheme(), (Object)this.bucketName);
        this.clientProvider = new S3ClientProvider(this.configuration);
        this.provider = provider;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        for (S3SeekableByteChannel channel : this.openChannels) {
            if (channel.isOpen()) {
                channel.close();
            }
            this.deregisterClosedChannel(channel);
        }
        this.provider.closeFileSystem(this);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(S3Path.getPath(this, "/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_FILE_ATTRIBUTE_VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        return S3Path.getPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("This method is not yet supported. Please raise a feature request describing your use case");
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException("This method is not yet supported. Please raise a feature request describing your use case");
    }

    S3NioSpiConfiguration configuration() {
        return this.configuration;
    }

    public S3ClientProvider clientProvider() {
        return this.clientProvider;
    }

    public void clientProvider(S3ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    S3AsyncClient client() {
        return this.clientProvider.generateClient(this.bucketName);
    }

    String bucketName() {
        return this.bucketName;
    }

    Set<Channel> getOpenChannels() {
        return Collections.unmodifiableSet(this.openChannels);
    }

    void registerOpenChannel(S3SeekableByteChannel channel) {
        this.openChannels.add(channel);
    }

    boolean deregisterClosedChannel(S3SeekableByteChannel closedChannel) {
        assert (!closedChannel.isOpen());
        return this.openChannels.remove(closedChannel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3FileSystem that = (S3FileSystem)o;
        return this.bucketName.equals(that.bucketName) && this.provider.getClass().getName().equals(that.provider.getClass().getName());
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.provider.getClass().getName());
    }
}

