/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CompletedCopy;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.nio.spi.s3.AsyncS3FileChannel;
import software.amazon.nio.spi.s3.S3BasicFileAttributeView;
import software.amazon.nio.spi.s3.S3BasicFileAttributes;
import software.amazon.nio.spi.s3.S3ClientProvider;
import software.amazon.nio.spi.s3.S3DirectoryStream;
import software.amazon.nio.spi.s3.S3FileChannel;
import software.amazon.nio.spi.s3.S3FileSystem;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3SeekableByteChannel;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;
import software.amazon.nio.spi.s3.util.S3FileSystemInfo;
import software.amazon.nio.spi.s3.util.TimeOutUtils;

public class S3FileSystemProvider
extends FileSystemProvider {
    static final String SCHEME = "s3";
    private static final Map<String, S3FileSystem> FS_CACHE = new ConcurrentHashMap<String, S3FileSystem>();
    protected S3NioSpiConfiguration configuration = new S3NioSpiConfiguration();
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected Map<String, S3FileSystem> getFsCache() {
        return Map.copyOf(FS_CACHE);
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme must be " + this.getScheme());
        }
        Map<String, ?> envMap = env;
        S3FileSystemInfo info = this.fileSystemInfo(uri);
        S3NioSpiConfiguration config = new S3NioSpiConfiguration().withEndpoint(info.endpoint()).withBucketName(info.bucket());
        if (info.accessKey() != null) {
            config.withCredentials(info.accessKey(), info.accessSecret());
        }
        String bucketName = config.getBucketName();
        try (S3AsyncClient client = new S3ClientProvider(config).configureCrtClient().build();){
            CreateBucketResponse createBucketResponse = (CreateBucketResponse)client.createBucket(bucketBuilder -> bucketBuilder.bucket(bucketName).acl(envMap.getOrDefault("acl", "").toString()).grantFullControl(envMap.getOrDefault("grantFullControl", "").toString()).grantRead(envMap.getOrDefault("grantRead", "").toString()).grantReadACP(envMap.getOrDefault("grantReadACP", "").toString()).grantWrite(envMap.getOrDefault("grantWrite", "").toString()).grantWriteACP(envMap.getOrDefault("grantWriteACP", "").toString()).createBucketConfiguration(confBuilder -> {
                if (envMap.containsKey("locationConstraint")) {
                    String loc = envMap.get("locationConstraint").toString();
                    if (loc.equals(Region.US_EAST_1.id())) {
                        loc = null;
                    }
                    confBuilder.locationConstraint(loc);
                }
            })).get(30L, TimeUnit.SECONDS);
            this.logger.debug("Create bucket response {}", (Object)createBucketResponse.toString());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BucketAlreadyOwnedByYouException || e.getCause() instanceof BucketAlreadyExistsException) {
                throw (FileSystemAlreadyExistsException)new FileSystemAlreadyExistsException(e.getCause().getMessage()).initCause(e.getCause());
            }
            throw new IOException(e.getMessage(), e.getCause());
        }
        catch (InterruptedException | TimeoutException | SdkException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException(e.getMessage(), e);
        }
        return this.getFileSystem(uri);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        S3FileSystemInfo info = this.fileSystemInfo(uri);
        return FS_CACHE.computeIfAbsent(info.key(), key -> {
            S3NioSpiConfiguration config = new S3NioSpiConfiguration().withEndpoint(info.endpoint()).withBucketName(info.bucket());
            if (info.accessKey() != null) {
                config.withCredentials(info.accessKey(), info.accessSecret());
            }
            return new S3FileSystem(this, config);
        });
    }

    @Override
    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Objects.requireNonNull(uri);
        return this.getFileSystem(uri).getPath(uri.getScheme() + ":/" + uri.getPath(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (Objects.isNull(options)) {
            options = Collections.emptySet();
        }
        S3Path s3Path = S3FileSystemProvider.checkPath(path);
        S3FileSystem fs = s3Path.getFileSystem();
        S3SeekableByteChannel channel = new S3SeekableByteChannel(s3Path, fs.client(), options);
        fs.registerOpenChannel(channel);
        return channel;
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        S3Path s3Path = S3FileSystemProvider.checkPath(dir);
        Object dirName = s3Path.toAbsolutePath().getKey();
        if (!s3Path.isDirectory()) {
            dirName = (String)dirName + "/";
        }
        try {
            return new S3DirectoryStream(s3Path.getFileSystem(), s3Path.bucketName(), (String)dirName, filter);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ExecutionException) {
                Exception cause = (Exception)e.getCause().getCause();
                if (cause instanceof NoSuchBucketException) {
                    throw new FileSystemNotFoundException("Bucket '" + s3Path.bucketName() + "' not found: NoSuchBucket");
                }
                if (cause instanceof S3Exception && ((S3Exception)cause).statusCode() == 403) {
                    throw new AccessDeniedException("Access to bucket '" + s3Path.bucketName() + "' denied", s3Path.toString(), cause.getMessage());
                }
                throw new IOException(cause.getMessage(), cause);
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Directory = S3FileSystemProvider.checkPath(dir);
        if (s3Directory.toString().equals("/") || s3Directory.toString().isEmpty()) {
            throw new FileAlreadyExistsException("Root directory already exists");
        }
        Object directoryKey = s3Directory.toRealPath(LinkOption.NOFOLLOW_LINKS).getKey();
        if (!((String)directoryKey).endsWith("/") && !((String)directoryKey).isEmpty()) {
            directoryKey = (String)directoryKey + "/";
        }
        Long timeOut = this.configuration.getTimeoutLow();
        TimeUnit unit = TimeUnit.MINUTES;
        try {
            s3Directory.getFileSystem().client().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(s3Directory.bucketName()).key((String)directoryKey).build(), AsyncRequestBody.empty()).get(timeOut, unit);
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "createDirectory", timeOut, unit);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        S3Path s3Path = S3FileSystemProvider.checkPath(path);
        String prefix = s3Path.toRealPath(LinkOption.NOFOLLOW_LINKS).getKey();
        String bucketName = s3Path.bucketName();
        S3AsyncClient s3Client = s3Path.getFileSystem().client();
        Long timeOut = this.configuration.getTimeoutLow();
        TimeUnit unit = TimeUnit.MINUTES;
        try {
            List<List<ObjectIdentifier>> keys = s3Path.isDirectory() ? S3FileSystemProvider.getContainedObjectBatches(s3Client, bucketName, prefix, timeOut, unit) : List.of(List.of((ObjectIdentifier)ObjectIdentifier.builder().key(prefix).build()));
            for (List<ObjectIdentifier> keyList : keys) {
                s3Client.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(keyList).build()).build()).get(timeOut, unit);
            }
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "delete", timeOut, unit);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (source.equals(target)) {
            return;
        }
        S3Path s3SourcePath = S3FileSystemProvider.checkPath(source);
        S3Path s3TargetPath = S3FileSystemProvider.checkPath(target);
        S3AsyncClient s3Client = s3SourcePath.getFileSystem().client();
        String sourceBucket = s3SourcePath.bucketName();
        Long timeOut = this.configuration.getTimeoutHigh();
        TimeUnit unit = TimeUnit.MINUTES;
        Function<S3Path, Boolean> fileExistsAndCannotReplace = this.cannotReplaceAndFileExistsCheck(options, s3Client);
        try {
            Object prefixWithSeparator;
            List<List<ObjectIdentifier>> sourceKeys;
            String sourcePrefix = s3SourcePath.toRealPath(LinkOption.NOFOLLOW_LINKS).getKey();
            if (s3SourcePath.isDirectory()) {
                sourceKeys = S3FileSystemProvider.getContainedObjectBatches(s3Client, sourceBucket, sourcePrefix, timeOut, unit);
                prefixWithSeparator = sourcePrefix;
            } else {
                sourceKeys = List.of(List.of((ObjectIdentifier)ObjectIdentifier.builder().key(sourcePrefix).build()));
                prefixWithSeparator = sourcePrefix.substring(0, sourcePrefix.lastIndexOf("/")) + "/";
            }
            try (S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(s3Client).build();){
                for (List<ObjectIdentifier> keyList : sourceKeys) {
                    for (ObjectIdentifier objectIdentifier : keyList) {
                        this.copyKey(objectIdentifier.key(), (String)prefixWithSeparator, sourceBucket, s3TargetPath, s3TransferManager, fileExistsAndCannotReplace).get(timeOut, unit);
                    }
                }
            }
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "copy", timeOut, unit);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.copy(source, target, options);
        this.delete(source);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.toRealPath(LinkOption.NOFOLLOW_LINKS).equals(path2.toRealPath(LinkOption.NOFOLLOW_LINKS));
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        for (AccessMode mode : modes) {
            if (mode != AccessMode.WRITE && mode != AccessMode.EXECUTE) continue;
            this.logger.warn("checkAccess: AccessMode '{}' is currently not checked by S3FileSystemProvider", (Object)mode);
        }
        S3Path s3Path = S3FileSystemProvider.checkPath(path.toRealPath(LinkOption.NOFOLLOW_LINKS));
        CompletableFuture<? extends S3Response> response = this.getCompletableFutureForHead(s3Path);
        Long timeOut = this.configuration.getTimeoutLow();
        TimeUnit unit = TimeUnit.MINUTES;
        try {
            IOException ioException = (IOException)((CompletableFuture)response.handleAsync((resp, ex) -> {
                if (ex != null) {
                    return new IOException((Throwable)ex);
                }
                if (resp instanceof ListObjectsV2Response) {
                    ListObjectsV2Response listResp = (ListObjectsV2Response)resp;
                    if (listResp.hasCommonPrefixes() && !listResp.commonPrefixes().isEmpty()) {
                        this.logger.debug("checkAccess - common prefixes: access is OK");
                        return null;
                    }
                    if (listResp.hasContents() && !listResp.contents().isEmpty()) {
                        this.logger.debug("checkAccess - contents: access is OK");
                        return null;
                    }
                    return new NoSuchFileException(s3Path.toString());
                }
                this.logger.debug("checkAccess: access is OK");
                return null;
            })).get(timeOut, unit);
            if (ioException != null) {
                throw ioException;
            }
        }
        catch (TimeoutException e) {
            throw TimeOutUtils.logAndGenerateExceptionOnTimeOut(this.logger, "checkAccess", timeOut, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<? extends S3Response> getCompletableFutureForHead(S3Path s3Path) {
        S3FileSystem fs = s3Path.getFileSystem();
        String bucketName = fs.bucketName();
        S3AsyncClient s3Client = fs.client();
        CompletableFuture response = s3Path.equals(s3Path.getRoot()) ? s3Client.headBucket(request -> request.bucket(bucketName)) : (s3Path.isDirectory() ? s3Client.listObjectsV2(req -> req.bucket(bucketName).prefix(s3Path.getKey())) : s3Client.headObject(req -> req.bucket(bucketName).key(s3Path.getKey())));
        return response;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Objects.requireNonNull(type, "the type of attribute view required cannot be null");
        S3Path s3Path = S3FileSystemProvider.checkPath(path);
        if (type.equals(BasicFileAttributeView.class)) {
            S3BasicFileAttributeView v = new S3BasicFileAttributeView(s3Path);
            return (V)v;
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Objects.requireNonNull(type);
        S3Path s3Path = S3FileSystemProvider.checkPath(path);
        if (type.equals(BasicFileAttributes.class)) {
            S3BasicFileAttributes a = S3BasicFileAttributes.get(s3Path, Duration.ofMinutes(this.configuration.getTimeoutLow()));
            return (A)a;
        }
        throw new UnsupportedOperationException("cannot read attributes of type: " + type);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        Objects.requireNonNull(attributes);
        S3Path s3Path = S3FileSystemProvider.checkPath(path);
        if (s3Path.isDirectory() || attributes.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        Predicate<String> attributesFilter = S3FileSystemProvider.attributesFilterFor(attributes);
        return S3BasicFileAttributes.get(s3Path, Duration.ofMinutes(this.configuration.getTimeoutLow())).asMap(attributesFilter);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("s3 file attributes cannot be modified by this class");
    }

    public void setConfiguration(S3NioSpiConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        S3FileSystem fs = (S3FileSystem)this.getFileSystem(path.toUri());
        S3SeekableByteChannel s3SeekableByteChannel = new S3SeekableByteChannel((S3Path)path, fs.client(), options);
        return new S3FileChannel(s3SeekableByteChannel);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        S3FileSystem fs = (S3FileSystem)this.getFileSystem(path.toUri());
        S3AsyncClient s3Client = fs.client();
        S3SeekableByteChannel byteChannel = new S3SeekableByteChannel((S3Path)path, s3Client, options);
        return new AsyncS3FileChannel(byteChannel);
    }

    void closeFileSystem(FileSystem fs) {
        for (String key : FS_CACHE.keySet()) {
            if (fs != FS_CACHE.get(key)) continue;
            try (FileSystem closeable = FS_CACHE.remove(key);){
                this.closeFileSystemIfOpen(closeable);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.closeFileSystemIfOpen(fs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeFileSystemIfOpen(FileSystem fs) throws IOException {
        if (fs.isOpen()) {
            fs.close();
        }
    }

    boolean exists(S3AsyncClient s3Client, S3Path path) throws InterruptedException, TimeoutException {
        try {
            s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.bucketName()).key(path.getKey()).build()).get(this.configuration.getTimeoutLow(), TimeUnit.MINUTES);
            return true;
        }
        catch (ExecutionException | NoSuchKeyException e) {
            this.logger.debug("Could not retrieve object head information", e);
            return false;
        }
    }

    S3FileSystemInfo fileSystemInfo(URI uri) {
        return new S3FileSystemInfo(uri);
    }

    private static List<List<ObjectIdentifier>> getContainedObjectBatches(S3AsyncClient s3Client, String bucketName, String prefix, long timeOut, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        String continuationToken = null;
        boolean hasMoreItems = true;
        ArrayList<List<ObjectIdentifier>> keys = new ArrayList<List<ObjectIdentifier>>();
        ListObjectsV2Request.Builder requestBuilder = ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix);
        while (hasMoreItems) {
            String finalContinuationToken = continuationToken;
            ListObjectsV2Response response = (ListObjectsV2Response)s3Client.listObjectsV2((ListObjectsV2Request)requestBuilder.continuationToken(finalContinuationToken).build()).get(timeOut, unit);
            List objects = response.contents().stream().filter(s3Object -> s3Object.key().equals(prefix) || s3Object.key().startsWith(prefix)).map(s3Object -> (ObjectIdentifier)ObjectIdentifier.builder().key(s3Object.key()).build()).collect(Collectors.toList());
            if (!objects.isEmpty()) {
                keys.add(objects);
            }
            hasMoreItems = response.isTruncated();
            continuationToken = response.nextContinuationToken();
        }
        return keys;
    }

    private static Predicate<String> attributesFilterFor(String attributes) {
        if (attributes.equals("*") || attributes.equals(SCHEME)) {
            return x -> true;
        }
        Set attrSet = Arrays.stream(attributes.split(",")).map(attr -> attr.replaceAll("^s3:", "")).collect(Collectors.toSet());
        return attrSet::contains;
    }

    private CompletableFuture<CompletedCopy> copyKey(String sourceObjectIdentifierKey, String sourcePrefix, String sourceBucket, S3Path targetPath, S3TransferManager transferManager, Function<S3Path, Boolean> fileExistsAndCannotReplaceFn) throws FileAlreadyExistsException {
        String sanitizedIdKey = sourceObjectIdentifierKey.replaceFirst(sourcePrefix, "");
        if (targetPath.isDirectory()) {
            targetPath = targetPath.resolve(sanitizedIdKey);
        }
        if (fileExistsAndCannotReplaceFn.apply(targetPath).booleanValue()) {
            throw new FileAlreadyExistsException("File already exists at the target key");
        }
        return transferManager.copy(CopyRequest.builder().copyObjectRequest((CopyObjectRequest)CopyObjectRequest.builder().checksumAlgorithm(ChecksumAlgorithm.SHA256).sourceBucket(sourceBucket).sourceKey(sourceObjectIdentifierKey).destinationBucket(targetPath.bucketName()).destinationKey(targetPath.getKey()).build()).build()).completionFuture();
    }

    private Function<S3Path, Boolean> cannotReplaceAndFileExistsCheck(CopyOption[] options, S3AsyncClient s3Client) {
        boolean canReplaceFile = Arrays.asList(options).contains(StandardCopyOption.REPLACE_EXISTING);
        return destination -> {
            if (canReplaceFile) {
                return false;
            }
            try {
                return this.exists(s3Client, (S3Path)destination);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        };
    }

    static S3Path checkPath(Path obj) {
        Objects.requireNonNull(obj);
        if (!(obj instanceof S3Path)) {
            throw new ProviderMismatchException();
        }
        return (S3Path)obj;
    }
}

