/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.nio.spi.s3.S3BasicFileAttributes;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3ReadAheadByteChannel;
import software.amazon.nio.spi.s3.S3TransferUtil;
import software.amazon.nio.spi.s3.S3WritableByteChannel;
import software.amazon.nio.spi.s3.config.S3NioSpiConfiguration;

class S3SeekableByteChannel
implements SeekableByteChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3SeekableByteChannel.class);
    private long position;
    private final S3Path path;
    private final ReadableByteChannel readDelegate;
    private final S3WritableByteChannel writeDelegate;
    private boolean closed;
    private long size = -1L;

    S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client, Set<? extends OpenOption> options) throws IOException {
        this(s3Path, s3Client, 0L, options, null, null);
    }

    private S3SeekableByteChannel(S3Path s3Path, S3AsyncClient s3Client, long startAt, Set<? extends OpenOption> options, Long timeout, TimeUnit timeUnit) throws IOException {
        this.position = startAt;
        this.path = s3Path;
        this.closed = false;
        s3Path.getFileSystem().registerOpenChannel(this);
        if (options.contains(StandardOpenOption.WRITE) && options.contains(StandardOpenOption.READ)) {
            throw new IOException("This channel does not support read and write access simultaneously");
        }
        if (options.contains(StandardOpenOption.SYNC) || options.contains(StandardOpenOption.DSYNC)) {
            throw new IOException("The SYNC/DSYNC options is not supported");
        }
        S3NioSpiConfiguration config = s3Path.getFileSystem().configuration();
        if (options.contains(StandardOpenOption.WRITE)) {
            LOGGER.debug("using S3WritableByteChannel as write delegate for path '{}'", (Object)s3Path.toUri());
            this.readDelegate = null;
            S3TransferUtil transferUtil = new S3TransferUtil(s3Client, timeout, timeUnit);
            this.writeDelegate = new S3WritableByteChannel(s3Path, s3Client, transferUtil, options);
            this.position = 0L;
        } else if (options.contains(StandardOpenOption.READ) || options.isEmpty()) {
            LOGGER.debug("using S3ReadAheadByteChannel as read delegate for path '{}'", (Object)s3Path.toUri());
            this.readDelegate = new S3ReadAheadByteChannel(s3Path, config.getMaxFragmentSize(), config.getMaxFragmentNumber(), s3Client, this, timeout, timeUnit);
            this.writeDelegate = null;
        } else {
            throw new IOException("Invalid channel mode");
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.validateOpen();
        if (this.readDelegate == null) {
            throw new NonReadableChannelException();
        }
        return this.readDelegate.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.validateOpen();
        if (this.writeDelegate == null) {
            throw new NonWritableChannelException();
        }
        int length = src.remaining();
        this.position += (long)length;
        return this.writeDelegate.write(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        this.validateOpen();
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition cannot be < 0");
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.readDelegate == null) {
            throw new NonReadableChannelException();
        }
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            this.position = newPosition;
            return this;
        }
    }

    @Override
    public long size() throws IOException {
        this.validateOpen();
        if (this.size < 0L) {
            this.fetchSize();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSize() throws IOException {
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            this.size = S3BasicFileAttributes.get(this.path, Duration.ofMinutes(1L)).size();
            LOGGER.debug("size of '{}' is '{}'", (Object)this.path.toUri(), (Object)this.size);
        }
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("Currently not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        S3SeekableByteChannel s3SeekableByteChannel = this;
        synchronized (s3SeekableByteChannel) {
            if (this.readDelegate != null) {
                this.readDelegate.close();
            }
            if (this.writeDelegate != null) {
                this.writeDelegate.close();
            }
            this.closed = true;
            this.path.getFileSystem().deregisterClosedChannel(this);
        }
    }

    private void validateOpen() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    ReadableByteChannel getReadDelegate() {
        return this.readDelegate;
    }

    WritableByteChannel getWriteDelegate() {
        return this.writeDelegate;
    }
}

