/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.nio.spi.s3.S3Path;

final class S3TransferUtil {
    private final S3AsyncClient client;
    private final Long timeout;
    private final TimeUnit timeUnit;

    S3TransferUtil(S3AsyncClient client, Long timeout, TimeUnit timeUnit) {
        this.client = client;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    void downloadToLocalFile(S3Path path, Path destination) throws InterruptedException, ExecutionException, TimeoutException {
        try (S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(this.client).build();){
            CompletableFuture downloadCompletableFuture = s3TransferManager.downloadFile((DownloadFileRequest)DownloadFileRequest.builder().getObjectRequest((GetObjectRequest)GetObjectRequest.builder().bucket(path.bucketName()).key(path.getKey()).build()).destination(destination).build()).completionFuture();
            if (this.timeout != null && this.timeUnit != null) {
                downloadCompletableFuture.get(this.timeout, this.timeUnit);
            } else {
                downloadCompletableFuture.join();
            }
        }
    }

    void uploadLocalFile(S3Path path, Path localFile) throws IOException {
        try (S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(this.client).build();){
            CompletableFuture uploadCompletableFuture = s3TransferManager.uploadFile((UploadFileRequest)UploadFileRequest.builder().putObjectRequest((PutObjectRequest)PutObjectRequest.builder().bucket(path.bucketName()).key(path.getKey()).contentType(Files.probeContentType(localFile)).build()).source(localFile).build()).completionFuture();
            if (this.timeout != null && this.timeUnit != null) {
                uploadCompletableFuture.get(this.timeout, this.timeUnit);
            } else {
                uploadCompletableFuture.join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Could not write to path:" + path, e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException("Could not write to path:" + path, e);
        }
    }
}

