/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.nio.spi.s3.S3FileSystemProvider;
import software.amazon.nio.spi.s3.S3Path;
import software.amazon.nio.spi.s3.S3TransferUtil;

class S3WritableByteChannel
implements WritableByteChannel {
    private final S3Path path;
    private final Path tempFile;
    private final SeekableByteChannel channel;
    private final S3TransferUtil s3TransferUtil;
    private boolean open;

    S3WritableByteChannel(S3Path path, S3AsyncClient client, S3TransferUtil s3TransferUtil, Set<? extends OpenOption> options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(client);
        this.s3TransferUtil = s3TransferUtil;
        this.path = path;
        try {
            S3FileSystemProvider fileSystemProvider = (S3FileSystemProvider)path.getFileSystem().provider();
            boolean exists = fileSystemProvider.exists(client, path);
            if (exists && options.contains(StandardOpenOption.CREATE_NEW)) {
                throw new FileAlreadyExistsException("File at path:" + path + " already exists");
            }
            if (!(exists || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.CREATE))) {
                throw new NoSuchFileException("File at path:" + path + " does not exist yet");
            }
            this.tempFile = Files.createTempFile("aws-s3-nio-", ".tmp", new FileAttribute[0]);
            if (exists) {
                s3TransferUtil.downloadToLocalFile(path, this.tempFile);
            }
            this.channel = Files.newByteChannel(this.tempFile, this.removeCreateNew(options), new FileAttribute[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Could not open the path:" + path, e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException("Could not open the path:" + path, e);
        }
        this.open = true;
    }

    private @NonNull Set<? extends OpenOption> removeCreateNew(Set<? extends OpenOption> options) {
        HashSet<? extends OpenOption> auxOptions = new HashSet<OpenOption>(options);
        auxOptions.remove(StandardOpenOption.CREATE_NEW);
        return Set.copyOf(auxOptions);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        if (!this.open) {
            return;
        }
        this.s3TransferUtil.uploadLocalFile(this.path, this.tempFile);
        Files.deleteIfExists(this.tempFile);
        this.open = false;
    }

    protected void force() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        this.s3TransferUtil.uploadLocalFile(this.path, this.tempFile);
    }
}

