/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.nio.spi.s3.util;

import java.net.URI;
import software.amazon.awssdk.services.s3.internal.BucketUtils;
import software.amazon.nio.spi.s3.util.S3FileSystemInfo;

public class S3XFileSystemInfo
extends S3FileSystemInfo {
    private static final String URI_PATH_SEPARATOR = "/";

    public S3XFileSystemInfo(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri can not be null");
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int pos = userInfo.indexOf(58);
            this.accessKey = pos < 0 ? userInfo : userInfo.substring(0, pos);
            this.accessSecret = pos < 0 ? null : userInfo.substring(pos + 1);
        }
        this.endpoint = uri.getHost();
        if (uri.getPort() > 0) {
            this.endpoint = this.endpoint + ":" + uri.getPort();
        }
        this.bucket = uri.getPath().split(URI_PATH_SEPARATOR)[1];
        BucketUtils.isValidDnsBucketName((String)this.bucket, (boolean)true);
        this.key = this.endpoint + URI_PATH_SEPARATOR + this.bucket;
        if (this.accessKey != null) {
            this.key = this.accessKey + "@" + this.key;
        }
    }
}

