/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import java.util.Arrays;
import java.util.Random;

public class ThresholdedImpute
implements Example {
    public static void main(String[] args) throws Exception {
        new ThresholdedImpute().run();
    }

    @Override
    public String command() {
        return "Thresholded_Imputation_example";
    }

    @Override
    public String description() {
        return "Thresholded Imputation Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 1;
        long count = 0L;
        int dropped = 0;
        int dimensions = baseDimensions * shingleSize;
        ThresholdedRandomCutForest forest = new ThresholdedRandomCutForest.Builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).precision(precision).anomalyRate(0.01).imputationMethod(ImputationMethod.RCF).forestMode(ForestMode.STREAMING_IMPUTE).transformMethod(TransformMethod.NORMALIZE_DIFFERENCE).adjustThreshold(true).build();
        long seed = new Random().nextLong();
        Random noisePRG = new Random(0L);
        System.out.println("seed = " + seed);
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData((int)(dataSize + shingleSize - 1), (int)50, (double)100.0, (double)5.0, (long)seed, (int)baseDimensions);
        int keyCounter = 0;
        for (double[] point : dataWithKeys.data) {
            if (noisePRG.nextDouble() < 0.2 && (keyCounter >= dataWithKeys.changeIndices.length || count != (long)dataWithKeys.changeIndices[keyCounter])) {
                ++dropped;
                if (keyCounter < dataWithKeys.changeIndices.length && count == (long)dataWithKeys.changeIndices[keyCounter]) {
                    System.out.println(" dropped sequence " + count + " INPUT " + Arrays.toString(point) + " CHANGE " + Arrays.toString(dataWithKeys.changes[keyCounter]));
                }
            } else {
                long newStamp = 100L * count + (long)(2 * noisePRG.nextInt(10)) - 5L;
                AnomalyDescriptor result = forest.process(point, newStamp);
                if (keyCounter < dataWithKeys.changeIndices.length && count == (long)dataWithKeys.changeIndices[keyCounter]) {
                    System.out.println("sequence " + count + " INPUT " + Arrays.toString(point) + " CHANGE " + Arrays.toString(dataWithKeys.changes[keyCounter]));
                    ++keyCounter;
                }
                if (result.getAnomalyGrade() != 0.0) {
                    int i;
                    System.out.print("sequence " + count + " RESULT value ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getCurrentInput()[i] + ", ");
                    }
                    System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
                    if (result.isExpectedValuesPresent()) {
                        if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                            System.out.print(-result.getRelativeIndex() + " steps ago, instead of ");
                            for (i = 0; i < baseDimensions; ++i) {
                                System.out.print(result.getPastValues()[i] + ", ");
                            }
                            System.out.print("expected ");
                            for (i = 0; i < baseDimensions; ++i) {
                                System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                                if (result.getPastValues()[i] == result.getExpectedValuesList()[0][i]) continue;
                                System.out.print("( " + (result.getPastValues()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                            }
                        } else {
                            System.out.print("expected ");
                            for (i = 0; i < baseDimensions; ++i) {
                                System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                                if (result.getCurrentInput()[i] == result.getExpectedValuesList()[0][i]) continue;
                                System.out.print("( " + (result.getCurrentInput()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                            }
                        }
                    }
                    System.out.println();
                }
            }
            ++count;
        }
        System.out.println("Dropped " + dropped + " out of " + count);
    }
}

