/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import java.util.Arrays;
import java.util.Random;

public class ThresholdedMultiDimensionalExample
implements Example {
    public static void main(String[] args) throws Exception {
        new ThresholdedMultiDimensionalExample().run();
    }

    @Override
    public String command() {
        return "Thresholded_Multi_Dim_example";
    }

    @Override
    public String description() {
        return "Thresholded Multi Dimensional Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 2;
        int dimensions = baseDimensions * shingleSize;
        ThresholdedRandomCutForest forest = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).precision(precision).anomalyRate(0.01).forestMode(ForestMode.STANDARD).build();
        long seed = new Random().nextLong();
        System.out.println("seed = " + seed);
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.generateShingledDataWithKey((int)dataSize, (int)50, (int)shingleSize, (int)baseDimensions, (long)seed);
        int keyCounter = 0;
        int count = 0;
        for (double[] point : dataWithKeys.data) {
            AnomalyDescriptor result = forest.process(point, 0L);
            if (keyCounter < dataWithKeys.changeIndices.length && count + shingleSize - 1 == dataWithKeys.changeIndices[keyCounter]) {
                System.out.println("timestamp " + (count + shingleSize - 1) + " CHANGE " + Arrays.toString(dataWithKeys.changes[keyCounter]));
                ++keyCounter;
            }
            if (result.getAnomalyGrade() != 0.0) {
                int i;
                System.out.print("timestamp " + (count + shingleSize - 1) + " RESULT value ");
                for (i = (shingleSize - 1) * baseDimensions; i < shingleSize * baseDimensions; ++i) {
                    System.out.print(result.getCurrentInput()[i] + ", ");
                }
                System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
                if (result.isExpectedValuesPresent()) {
                    if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                        System.out.print(-result.getRelativeIndex() + " steps ago, instead of ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getPastValues()[i] + ", ");
                        }
                        System.out.print("expected ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                            if (result.getPastValues()[i] == result.getExpectedValuesList()[0][i]) continue;
                            System.out.print("( " + (result.getPastValues()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                        }
                    } else {
                        System.out.print("expected ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                            if (result.getCurrentInput()[(shingleSize - 1) * baseDimensions + i] == result.getExpectedValuesList()[0][i]) continue;
                            System.out.print("( " + (result.getCurrentInput()[(shingleSize - 1) * baseDimensions + i] - result.getExpectedValuesList()[0][i]) + " ) ");
                        }
                    }
                }
                System.out.println();
            }
            ++count;
        }
    }
}

