/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.serialization;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.executor.SamplerPlusTree;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;

public class ProtostuffExampleWithDynamicLambda
implements Example {
    public static void main(String[] args) throws Exception {
        new ProtostuffExampleWithDynamicLambda().run();
    }

    @Override
    public String command() {
        return "protostuff_dynamic";
    }

    @Override
    public String description() {
        return "serialize a Random Cut Forest with the protostuff library";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        byte[] bytes;
        int dimensions = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_64;
        RandomCutForest forest = RandomCutForest.builder().compact(true).dimensions(dimensions).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
        int dataSize = 4 * sampleSize;
        NormalMixtureTestData testData = new NormalMixtureTestData();
        for (double[] point : testData.generateTestData(dataSize, dimensions)) {
            forest.update(point);
        }
        RandomCutForestMapper mapper = new RandomCutForestMapper();
        mapper.setSaveExecutorContextEnabled(true);
        Schema schema = RuntimeSchema.getSchema(RandomCutForestState.class);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            RandomCutForestState state = mapper.toState(forest);
            bytes = ProtostuffIOUtil.toByteArray((Object)state, (Schema)schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        System.out.printf("dimensions = %d, numberOfTrees = %d, sampleSize = %d, precision = %s%n", dimensions, numberOfTrees, sampleSize, precision);
        System.out.printf("protostuff size = %d bytes%n", bytes.length);
        RandomCutForestState state2 = (RandomCutForestState)schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)state2, (Schema)schema);
        RandomCutForest forest2 = mapper.toModel(state2);
        double saveLambda = forest.getTimeDecay();
        forest.setTimeDecay(10.0 * forest.getTimeDecay());
        forest2.setTimeDecay(10.0 * forest2.getTimeDecay());
        for (int i = 0; i < numberOfTrees; ++i) {
            CompactSampler sampler = (CompactSampler)((SamplerPlusTree)forest.getComponents().get(i)).getSampler();
            CompactSampler sampler2 = (CompactSampler)((SamplerPlusTree)forest2.getComponents().get(i)).getSampler();
            if (sampler.getMaxSequenceIndex() != sampler2.getMaxSequenceIndex()) {
                throw new IllegalStateException("Incorrect sampler state");
            }
            if (sampler.getMostRecentTimeDecayUpdate() != sampler2.getMostRecentTimeDecayUpdate()) {
                throw new IllegalStateException("Incorrect sampler state");
            }
            if (sampler2.getMostRecentTimeDecayUpdate() == (long)(dataSize - 1)) continue;
            throw new IllegalStateException("Incorrect sampler state");
        }
        int testSize = 100;
        double delta = Math.log(sampleSize) / Math.log(2.0) * 0.05;
        int differences = 0;
        int anomalies = 0;
        for (double[] point : testData.generateTestData(testSize, dimensions)) {
            double score = forest.getAnomalyScore(point);
            double score2 = forest2.getAnomalyScore(point);
            if (score > 1.0 || score2 > 1.0) {
                ++anomalies;
                if (Math.abs(score - score2) > delta) {
                    ++differences;
                }
            }
            forest.update(point);
            forest2.update(point);
        }
        if (anomalies == 0) {
            throw new IllegalStateException("test data did not produce any anomalies");
        }
        if ((double)differences >= 0.01 * (double)testSize) {
            throw new IllegalStateException("restored forest does not agree with original forest");
        }
        System.out.println("Looks good!");
    }
}

