/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.GlobalLocalAnomalyDetector;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.returntypes.GenericAnomalyDescriptor;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.testutils.ExampleDataSets;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Random;

public class NumericGLADexample
implements Example {
    public static void main(String[] args) throws Exception {
        new NumericGLADexample().run();
    }

    @Override
    public String command() {
        return "An example of Global-Local Anomaly Detector on numeric vectors";
    }

    @Override
    public String description() {
        return "An example of Global-Local Anomaly Detector on numeric vectors";
    }

    @Override
    public void run() throws Exception {
        long randomSeed = new Random().nextLong();
        System.out.println("Seed " + randomSeed);
        int dataSize = 2000;
        double range = 10.0;
        int numberOfFans = 3;
        double[][] data = this.shiftedEllipse(dataSize, 7, range / 2.0, numberOfFans);
        int truePos = 0;
        int falsePos = 0;
        int falseNeg = 0;
        int truePosRCF = 0;
        int falsePosRCF = 0;
        int falseNegRCF = 0;
        int reservoirSize = dataSize;
        double timedecay = 1.0 / (double)reservoirSize;
        GlobalLocalAnomalyDetector reservoir = ((GlobalLocalAnomalyDetector.Builder)((GlobalLocalAnomalyDetector.Builder)((GlobalLocalAnomalyDetector.Builder)GlobalLocalAnomalyDetector.builder().randomSeed(42L)).numberOfRepresentatives(3).timeDecay(timedecay)).capacity(reservoirSize)).build();
        reservoir.setGlobalDistance(Summarizer::L2distance);
        double zFactor = 6.0;
        reservoir.setZfactor(zFactor);
        ThresholdedRandomCutForest test = ThresholdedRandomCutForest.builder().dimensions(2).shingleSize(1).randomSeed(77L).timeDecay(timedecay).forestMode(ForestMode.DISTANCE).build();
        test.setZfactor(zFactor);
        String name = "clustering_example";
        BufferedWriter file = new BufferedWriter(new FileWriter(name));
        boolean printData = true;
        boolean printAnomalies = false;
        boolean printFlaggedRCF = false;
        boolean printFlaggedGLAD = true;
        Random noiseGen = new Random(randomSeed + 1L);
        for (int degree = 0; degree < 360; ++degree) {
            int index = 0;
            while (index < data.length) {
                float[] vec;
                boolean injected = false;
                if (noiseGen.nextDouble() < 0.005) {
                    injected = true;
                    double[] candAnomaly = new double[]{range / 2.0 * noiseGen.nextDouble() + range / 2.0, 0.1 * (2.0 * noiseGen.nextDouble() - 1.0)};
                    int antiFan = noiseGen.nextInt(numberOfFans);
                    vec = CommonUtils.toFloatArray((double[])ExampleDataSets.rotateClockWise((double[])candAnomaly, (double)(Math.PI * -2 * (double)(degree + 180 * (1 + 2 * antiFan) / numberOfFans) / 360.0)));
                    if (printAnomalies) {
                        file.append(vec[0] + " " + vec[1] + " " + 0.0 + "\n");
                    }
                } else {
                    vec = CommonUtils.toFloatArray((double[])ExampleDataSets.rotateClockWise((double[])data[index], (double)(Math.PI * -2 * (double)degree / 360.0)));
                    if (printData) {
                        file.append(vec[0] + " " + vec[1] + " " + 0.0 + "\n");
                    }
                    ++index;
                }
                GenericAnomalyDescriptor result = reservoir.process((Object)vec, 1.0f, null, true);
                AnomalyDescriptor res = test.process(CommonUtils.toDoubleArray((float[])vec), 0L);
                double grade = res.getAnomalyGrade();
                if (injected) {
                    if (result.getAnomalyGrade() > 0.0) {
                        ++truePos;
                    } else {
                        ++falseNeg;
                    }
                    if (grade > 0.0) {
                        ++truePosRCF;
                    } else {
                        ++falseNegRCF;
                    }
                } else {
                    if (result.getAnomalyGrade() > 0.0) {
                        ++falsePos;
                    }
                    if (grade > 0.0) {
                        ++falsePosRCF;
                    }
                }
                if (printFlaggedRCF && grade > 0.0) {
                    file.append(vec[0] + " " + vec[1] + " " + grade + "\n");
                    continue;
                }
                if (!printFlaggedGLAD || !(result.getAnomalyGrade() > 0.0)) continue;
                file.append(vec[0] + " " + vec[1] + " " + result.getAnomalyGrade() + "\n");
            }
            if (printAnomalies || printData || printFlaggedRCF || printFlaggedGLAD) {
                file.append("\n");
                file.append("\n");
            }
            if (falsePos + truePos == 0) {
                throw new IllegalStateException("");
            }
            CommonUtils.checkArgument((falseNeg + truePos == falseNegRCF + truePosRCF ? 1 : 0) != 0, (String)" incorrect accounting");
            System.out.println(" at degree " + degree + " injected " + (truePos + falseNeg));
            System.out.print("Precision = " + this.precision(truePos, falsePos));
            System.out.println(" Recall = " + this.recall(truePos, falseNeg));
            System.out.print("RCF Distance Mode Precision = " + this.precision(truePosRCF, falsePosRCF));
            System.out.println(" RCF Distance Mode Recall = " + this.recall(truePosRCF, falseNegRCF));
        }
    }

    public double[][] shiftedEllipse(int dataSize, int seed, double shift, int fans) {
        NormalMixtureTestData generator = new NormalMixtureTestData(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        double[][] data = generator.generateTestData(dataSize, 2, seed);
        Random prg = new Random(0L);
        for (int i = 0; i < dataSize; ++i) {
            int nextFan = prg.nextInt(fans);
            double[] dArray = data[i];
            dArray[1] = dArray[1] * (1.0 / (double)fans);
            double[] dArray2 = data[i];
            dArray2[0] = dArray2[0] * 2.0;
            double[] dArray3 = data[i];
            dArray3[0] = dArray3[0] + (shift + 1.0 / (double)fans);
            data[i] = ExampleDataSets.rotateClockWise((double[])data[i], (double)(Math.PI * 2 * (double)nextFan / (double)fans));
        }
        return data;
    }

    double precision(int truePos, int falsePos) {
        return truePos + falsePos > 0 ? 1.0 * (double)truePos / (double)(truePos + falsePos) : 1.0;
    }

    double recall(int truePos, int falseNeg) {
        return truePos + falseNeg > 0 ? 1.0 * (double)truePos / (double)(truePos + falseNeg) : 1.0;
    }
}

