/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.SequentialAnalysis;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class SequentialAnomalyExample
implements Example {
    public static void main(String[] args) throws Exception {
        new SequentialAnomalyExample().run();
    }

    @Override
    public String command() {
        return "Sequential_analysis_example";
    }

    @Override
    public String description() {
        return "Sequential Analysis Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 8;
        int numberOfTrees = 50;
        int sampleSize = 256;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 2;
        long seed = new Random().nextLong();
        System.out.println("seed = " + seed);
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData((int)(dataSize + shingleSize - 1), (int)50, (double)100.0, (double)5.0, (long)seed, (int)baseDimensions);
        double timeDecay = 1.0 / (double)(10 * sampleSize);
        List anomalies = SequentialAnalysis.detectAnomalies((double[][])dataWithKeys.data, (int)shingleSize, (int)sampleSize, (double)timeDecay, (TransformMethod)TransformMethod.NONE);
        int keyCounter = 0;
        for (AnomalyDescriptor result : anomalies) {
            int i;
            while (keyCounter < dataWithKeys.changeIndices.length && (long)dataWithKeys.changeIndices[keyCounter] <= result.getInternalTimeStamp()) {
                System.out.println("timestamp " + dataWithKeys.changeIndices[keyCounter] + " CHANGE " + Arrays.toString(dataWithKeys.changes[keyCounter]));
                ++keyCounter;
            }
            if (result.getAnomalyGrade() == 0.0) continue;
            System.out.print("timestamp " + result.getInternalTimeStamp() + " RESULT value ");
            for (i = 0; i < baseDimensions; ++i) {
                System.out.print(result.getCurrentInput()[i] + ", ");
            }
            System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
            if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                System.out.print(-result.getRelativeIndex() + " step(s) ago, ");
            }
            if (result.isExpectedValuesPresent()) {
                if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                    System.out.print("instead of ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getPastValues()[i] + ", ");
                    }
                    System.out.print("expected ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                        if (result.getPastValues()[i] == result.getExpectedValuesList()[0][i]) continue;
                        System.out.print("( " + (result.getPastValues()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                    }
                } else {
                    System.out.print("expected ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                        if (result.getCurrentInput()[i] == result.getExpectedValuesList()[0][i]) continue;
                        System.out.print("( " + (result.getCurrentInput()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                    }
                }
            } else {
                System.out.print("insufficient data to provide expected values");
            }
            System.out.println();
        }
    }
}

