/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;

public class ThresholdedForecast
implements Example {
    public static void main(String[] args) throws Exception {
        new ThresholdedForecast().run();
    }

    @Override
    public String command() {
        return "Thresholded_Forecast_example";
    }

    @Override
    public String description() {
        return "Example of Forecast using Thresholded RCF";
    }

    @Override
    public void run() throws Exception {
        int i;
        int sampleSize = 256;
        int baseDimensions = 1;
        long seed = 100L;
        int length = 4 * sampleSize;
        int outputAfter = 128;
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData((int)length, (int)50, (double)100.0, (double)10.0, (long)seed, (int)baseDimensions, (boolean)true);
        System.out.println(dataWithKeys.changes.length + " anomalies injected ");
        int horizon = 60;
        int shingleSize = 30;
        ThresholdedRandomCutForest forest = new ThresholdedRandomCutForest.Builder().compact(true).dimensions(baseDimensions * shingleSize).precision(Precision.FLOAT_32).randomSeed(seed).internalShinglingEnabled(true).shingleSize(shingleSize).outputAfter(outputAfter).transformMethod(TransformMethod.NORMALIZE).build();
        if (forest.getTransformMethod() == TransformMethod.NORMALIZE_DIFFERENCE || forest.getTransformMethod() == TransformMethod.DIFFERENCE) {
            horizon = Math.min(horizon, shingleSize / 2 + 1);
        }
        double[] error = new double[horizon];
        double[] lowerError = new double[horizon];
        double[] upperError = new double[horizon];
        for (int j = 0; j < dataWithKeys.data.length; ++j) {
            TimedRangeVector extrapolate = forest.extrapolate(horizon, true, 1.0);
            RangeVector forecast = extrapolate.rangeVector;
            for (int i2 = 0; i2 < horizon; ++i2) {
                System.out.println(j + i2 + " " + forecast.values[i2] + " " + forecast.upper[i2] + " " + forecast.lower[i2]);
                if (j <= outputAfter + shingleSize - 1 || j + i2 >= dataWithKeys.data.length) continue;
                double t = dataWithKeys.data[j + i2][0] - (double)forecast.values[i2];
                int n = i2;
                error[n] = error[n] + t * t;
                t = dataWithKeys.data[j + i2][0] - (double)forecast.lower[i2];
                int n2 = i2;
                lowerError[n2] = lowerError[n2] + t * t;
                t = dataWithKeys.data[j + i2][0] - (double)forecast.upper[i2];
                int n3 = i2;
                upperError[n3] = upperError[n3] + t * t;
            }
            System.out.println();
            System.out.println();
            forest.process(dataWithKeys.data[j], (long)j);
        }
        System.out.println(forest.getTransformMethod().name() + " RMSE (as horizon increases) ");
        for (i = 0; i < horizon; ++i) {
            double t = error[i] / (double)(dataWithKeys.data.length - shingleSize + 1 - outputAfter - i);
            System.out.print(Math.sqrt(t) + " ");
        }
        System.out.println();
        System.out.println("RMSE Lower (as horizon increases)");
        for (i = 0; i < horizon; ++i) {
            double t = lowerError[i] / (double)(dataWithKeys.data.length - shingleSize + 1 - outputAfter - i);
            System.out.print(Math.sqrt(t) + " ");
        }
        System.out.println();
        System.out.println("RMSE Upper (as horizon increases)");
        for (i = 0; i < horizon; ++i) {
            double t = upperError[i] / (double)(dataWithKeys.data.length - shingleSize + 1 - outputAfter - i);
            System.out.print(Math.sqrt(t) + " ");
        }
        System.out.println();
    }
}

